/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Usertoken user tab.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenUser', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-usertoken-user',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      title: NX.I18n.get('UserToken_UserTokenUser_Title'),

      settingsForm: [
        {
          xtype: 'nx-settingsform',
          itemId: 'resetAll',
          title: NX.I18n.get('UserToken_UserTokenUser_ResetToken_Title'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserToken_UserTokenUser_ResetToken_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserToken_UserTokenUser_ResetToken_Button'), action: 'reset', ui: 'nx-primary', iconCls: 'x-fa fa-lock' }
          ]
        }
      ]
    });

    this.callParent();
  }

});
