/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags feature panel.
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.TagFeature', {
  extend: 'NX.view.drilldown.Drilldown',
  alias: 'widget.nx-proui-tags-feature',

  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      iconCls: 'x-fa fa-tag',

      masters: [
        { xtype: 'nx-proui-tags-list' }
      ],

      tabs: { xtype: 'nx-proui-tag-panel' },

      nxActions: [{
        xtype: 'button',
        text: NX.I18n.get('TagFeature_FindTaggedComponents_Button'),
        iconCls: 'x-fa fa-search',
        action: 'search',
        disabled: false
      }]
    });

    this.callParent();
  }
});
