/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * HealthCheck repository detail controller.
 *
 * Adds a detail button to health check summary window shown when hovering over enabled repositories in repository grid.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.HealthCheckRepositoryDetail', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Windows'
  ],

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      component: {
        'nx-coreui-healthcheck-summary': {
          afterrender: me.addDetailButton
        },
        'nx-coreui-healthcheck-summary button[action=viewdetail]': {
          click: me.viewDetail
        }
      }
    });
  },

  /**
   * Add 'View Detailed Report' to Summary tooltip window.
   *
   * @private
   * @param {NX.coreui.view.healthcheck.HealthCheckSummary} win summary window
   */
  addDetailButton: function(win) {
    var statusModel = win['statusModel'],
        toolbar;

    if (statusModel && statusModel.get('detailedReportSupported')) {
      toolbar = win.getDockedItems('toolbar[dock="bottom"]')[0];
      if (statusModel.get('detailUrl')) {
        toolbar.add([
          '->',
          {
            xtype: 'button', text: 'View Detailed Report', action: 'viewdetail',
            disabled: !NX.Permissions.check('nexus:healthcheckdetail:read')
          }
        ]);
      }
      else {
        toolbar.add([
          '->',
          'The next analysis will include the detailed report.'
        ]);
      }
    }
  },

  /**
   * Show detail report into a new browser tab/window.
   *
   * @private
   * @param {Ext.Button} button 'View Detailed Report' button
   */
  viewDetail: function(button) {
    var win = button.up('window'),
        statusModel = win['statusModel'];

    NX.Windows.open(statusModel.get('detailUrl'));
    win.close();
  }

});
