/*
 * Sonatype Nexus (TM) Open Source Version
 * Copyright (c) 2008-present Sonatype, Inc.
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/oss/attributions.
 *
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License Version 1.0,
 * which accompanies this distribution and is available at http://www.eclipse.org/legal/epl-v10.html.
 *
 * Sonatype Nexus (TM) Open Source Version is distributed with Sencha Ext JS pursuant to a FLOSS Exception agreed upon
 * between Sonatype, Inc. and Sencha Inc. Sencha Ext JS is licensed under GPL v3 and cannot be redistributed as part of a
 * closed source work.
 *
 * Sonatype Nexus (TM) Professional Version is available from Sonatype, Inc. "Sonatype" and "Sonatype Nexus" are trademarks
 * of Sonatype, Inc. Apache Maven is a trademark of the Apache Software Foundation. M2eclipse is a trademark of the
 * Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * LDAP Server User & Group login credentials window.
 *
 * @since 3.0
 */
Ext.define('NX.coreui.view.ldap.LdapServerUserAndGroupLoginCredentials', {
  extend: 'Ext.window.Window',
  alias: 'widget.nx-coreui-ldapserver-userandgroup-login-credentials',
  requires: [
    'NX.Icons',
    'NX.I18n'
  ],

  /**
   * @protected
   */
  initComponent: function () {
    var me = this;

    if (!me.message) {
      me.message = NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Text');
    }

    Ext.apply(me, {
      ui: 'nx-inset',
      title: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Title'),
      layout: 'fit',
      autoShow: true,
      modal: true,
      constrain: true,
      width: 360,
      defaultFocus: 'username',
      items: {
        xtype: 'form',
        defaultType: 'textfield',
        defaults: {
          labelAlign: 'left',
          labelWidth: 140,
          anchor: '100%'
        },
        items: [
          {
            xtype: 'panel',
            layout: 'hbox',
            style: {
              // FIXME: sort out common style here for dialogs
              marginBottom: '10px'
            },
            items: [
              { xtype: 'component', html: NX.Icons.img('authenticate', 'x32') },
              { xtype: 'component', html: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Input_Text') }
            ]
          },
          {
            name: 'username',
            itemId: 'username',
            fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Username_FieldLabel'),
            allowBlank: false,
            validateOnBlur: false // allow cancel to be clicked w/o validating this to be non-blank
          },
          {
            name: 'password',
            itemId: 'password',
            fieldLabel: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Password_FieldLabel'),
            inputType: 'password',
            allowBlank: false,
            validateOnBlur: false // allow cancel to be clicked w/o validating this to be non-blank
          }
        ],

        buttonAlign: 'left',
        buttons: [
          { text: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Submit_Button'), action: 'verifylogin', formBind: true, bindToEnter: true, ui: 'nx-primary' },
          { text: NX.I18n.get('Ldap_LdapServerUserAndGroupLoginCredentials_Cancel_Button'), handler: me.close, scope: me }
        ]
      }
    });

    me.callParent();
  }

});
