Ext.define("NX.s3blobstore.app.PluginStrings",{"@aggregate_priority":90,singleton:true,requires:["NX.I18n"],keys:{S3Blobstore_Help:'<em>S3 blob stores require specific permissions to support full provisioning and functionality through Nexus Repository Manager. Consult our <a href="https://links.sonatype.com/products/nexus/blobstores/s3/docs" target="_blank">documentation</a> for the specific set of permissions required.</em>',S3Blobstore_Region_FieldLabel:"Region",S3Blobstore_Region_HelpText:"The AWS Region to use",S3Blobstore_Bucket_FieldLabel:"Bucket",S3Blobstore_Bucket_HelpText:"S3 Bucket Name (must be between 3 and 63 characters long containing only lower-case characters, numbers, periods, and dashes)",S3Blobstore_Prefix_FieldLabel:"Prefix",S3Blobstore_Prefix_HelpText:"S3 Path prefix",S3Blobstore_Expiration_FieldLabel:"Expiration Days",S3Blobstore_Expiration_HelpText:"How many days until deleted blobs are finally removed from the S3 bucket (-1 to disable)",S3Blobstore_Authentication_Title:"Authentication",S3Blobstore_Authentication_AccessKeyId:"Access Key ID",S3Blobstore_Authentication_SecretAccessKey:"Secret Access Key",S3Blobstore_Authentication_AssumeRoleArn:"Assume Role ARN (Optional)",S3Blobstore_Authentication_SessionToken:"Session Token ARN (Optional)",S3Blobstore_EncryptionSettings_Title:"Encryption",S3Blobstore_EncryptionSettings_Type_FieldLabel:"Encryption Type",S3Blobstore_EncryptionSettings_Type_HelpText:"The type of encryption for objects in the S3 Blob Store",S3Blobstore_EncryptionSettings_KeyID_FieldLabel:"KMS Key ID (Optional)",S3Blobstore_EncryptionSettings_KeyID_HelpText:"If using KMS encryption, you can supply a Key ID. If left blank, then the default will be used",S3Blobstore_AdvancedConnectionSettings_Title:"Advanced Connection Settings",S3Blobstore_AdvancedConnectionSettings_EndPointUrl_FieldLabel:"Endpoint URL",S3Blobstore_AdvancedConnectionSettings_EndPointUrl_HelpText:"A custom endpoint URL for third party object stores using the S3 API",S3Blobstore_AdvancedConnectionSettings_MaxConnectionPoolSize_FieldLabel:"Max Connection Pool Size",S3Blobstore_AdvancedConnectionSettings_MaxConnectionPoolSize_HelpText:"When set this value overrides the default connection pool size defined by Nexus, or the AWS Client",S3Blobstore_AdvancedConnectionSettings_SignatureVersion_FieldLabel:"Signature Version",S3Blobstore_AdvancedConnectionSettings_SignatureVersion_HelpText:"An API signature version which may be required for third party object stores using the S3 API",S3Blobstore_AdvancedConnectionSettings_PathStyleAccess_FieldLabel:"Use path-style access",S3Blobstore_AdvancedConnectionSettings_PathStyleAccess_HelpText:"Setting this flag will result in path-style access being used for all requests"}},function(a){NX.I18n.register(a)});Ext.define("NX.s3blobstore.app.PluginConfig",{"@aggregate_priority":100,requires:["NX.s3blobstore.app.PluginStrings"],controllers:[{id:"NX.s3blobstore.controller.S3Blobstore",active:true}]});Ext.define("NX.s3blobstore.view.BlobstoreSettings",{extend:"NX.view.SettingsPanel",alias:"widget.nx-blobstore-settings-s3",requires:["Ext.data.Store","NX.I18n"],settingsForm:[{xtype:"nx-responsive-panel",layout:{type:"hbox",align:"center",pack:"center"},items:[{xtype:"panel",bodypadding:"10px",width:"85%",html:NX.I18n.get("S3Blobstore_Help")}]},{xtype:"combo",name:"property_region",fieldLabel:NX.I18n.get("S3Blobstore_Region_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_Region_HelpText"),itemCls:"required-field",displayField:"name",valueField:"id",editable:true,forceSelection:false,queryMode:"local",triggerAction:"all",emptyText:"Select...",selectOnFocus:false,allowBlank:false,listeners:{added:function(){var a=this;a.getStore().load()},afterrender:function(){var a=this;if(!a.getValue()){a.setValue("DEFAULT")}}},store:"NX.s3blobstore.store.S3Region"},{xtype:"textfield",name:"property_bucket",fieldLabel:NX.I18n.get("S3Blobstore_Bucket_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_Bucket_HelpText"),allowBlank:false},{xtype:"textfield",name:"property_prefix",fieldLabel:NX.I18n.get("S3Blobstore_Prefix_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_Prefix_HelpText"),allowBlank:true},{xtype:"numberfield",name:"property_expiration",fieldLabel:NX.I18n.get("S3Blobstore_Expiration_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_Expiration_HelpText"),value:Number("3"),minValue:Number("-1"),allowBlank:false},{xtype:"nx-optionalfieldset",title:NX.I18n.get("S3Blobstore_Authentication_Title"),checkboxToggle:true,checkboxName:"authEnabled",collapsed:true,items:[{xtype:"textfield",name:"property_accessKeyId",fieldLabel:NX.I18n.get("S3Blobstore_Authentication_AccessKeyId"),allowBlank:false},{xtype:"textfield",inputType:"password",name:"property_secretAccessKey",fieldLabel:NX.I18n.get("S3Blobstore_Authentication_SecretAccessKey"),allowBlank:false},{xtype:"textfield",name:"property_assumeRole",fieldLabel:NX.I18n.get("S3Blobstore_Authentication_AssumeRoleArn"),allowBlank:true},{xtype:"textfield",name:"property_sessionToken",fieldLabel:NX.I18n.get("S3Blobstore_Authentication_SessionToken"),allowBlank:true}]},{xtype:"nx-optionalfieldset",title:NX.I18n.get("S3Blobstore_EncryptionSettings_Title"),checkboxToggle:true,checkboxName:"encryptionSettingsEnabled",collapsed:true,listeners:{expand:function(){var b=this;var a=b.down("[name=property_encryption_type]");if(!a.getValue()){a.setValue("none")}}},items:[{xtype:"combo",name:"property_encryption_type",fieldLabel:NX.I18n.get("S3Blobstore_EncryptionSettings_Type_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_EncryptionSettings_Type_HelpText"),itemCls:"required-field",displayField:"name",valueField:"id",editable:false,forceSelection:true,queryMode:"local",triggerAction:"all",emptyText:"Select...",selectOnFocus:false,allowBlank:true,listeners:{added:function(){var a=this;a.getStore().load()}},store:"NX.s3blobstore.store.S3EncryptionType"},{xtype:"textfield",name:"property_encryption_key",fieldLabel:NX.I18n.get("S3Blobstore_EncryptionSettings_KeyID_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_EncryptionSettings_KeyID_HelpText"),allowBlank:true}]},{xtype:"nx-optionalfieldset",title:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_Title"),checkboxToggle:true,checkboxName:"advancedConnectionSettingsEnabled",collapsed:true,listeners:{expand:function(){var b=this;var a=b.down("[name=property_signertype]");if(!a.getValue()){a.setValue("DEFAULT")}}},items:[{xtype:"textfield",name:"property_endpoint",fieldLabel:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_EndPointUrl_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_EndPointUrl_HelpText"),allowBlank:true},{xtype:"textfield",name:"property_max_connection_pool_size",fieldLabel:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_MaxConnectionPoolSize_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_MaxConnectionPoolSize_HelpText"),minValue:Number("-1"),allowBlank:true},{xtype:"combo",name:"property_signertype",fieldLabel:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_SignatureVersion_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_SignatureVersion_HelpText"),itemCls:"required-field",displayField:"name",valueField:"id",editable:false,forceSelection:true,queryMode:"local",triggerAction:"all",emptyText:"Select...",selectOnFocus:false,allowBlank:true,listeners:{added:function(){var a=this;a.getStore().load()}},store:"NX.s3blobstore.store.S3SignerType"},{xtype:"checkbox",name:"property_forcepathstyle",fieldLabel:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_PathStyleAccess_FieldLabel"),helpText:NX.I18n.get("S3Blobstore_AdvancedConnectionSettings_PathStyleAccess_HelpText")}]}],exportProperties:function(a){var b={};Ext.Object.each(a,function(c,d){if(c.startsWith("property_")){b[c.replace("property_","")]=String(d)}});return b}});Ext.define("NX.s3blobstore.model.S3SignerType",{extend:"Ext.data.Model",fields:[{name:"id",type:"string",sortType:"asUCText"},{name:"name",type:"string",sortType:"asUCText"},{name:"order",sortType:"asInt"}]});Ext.define("NX.s3blobstore.model.S3Region",{extend:"Ext.data.Model",fields:[{name:"id",type:"string",sortType:"asUCText"},{name:"name",type:"string",sortType:"asUCText"},{name:"order",sortType:"asInt"}]});Ext.define("NX.s3blobstore.store.S3Region",{extend:"Ext.data.Store",model:"NX.s3blobstore.model.S3Region",proxy:{type:"direct",paramsAsHash:false,api:{read:"NX.direct.s3_S3.regions"},reader:{type:"json",rootProperty:"data",successProperty:"success"}},sorters:[{property:"order",direction:"ASC"},{property:"name",direction:"ASC"}]});Ext.define("NX.s3blobstore.model.S3EncryptionType",{extend:"Ext.data.Model",fields:[{name:"id",type:"string",sortType:"asUCText"},{name:"name",type:"string",sortType:"asUCText"},{name:"order",sortType:"asInt"}]});Ext.define("NX.s3blobstore.store.S3SignerType",{extend:"Ext.data.Store",model:"NX.s3blobstore.model.S3SignerType",proxy:{type:"direct",paramsAsHash:false,api:{read:"NX.direct.s3_S3.signertypes"},reader:{type:"json",rootProperty:"data",successProperty:"success"}},sorters:[{property:"order",direction:"ASC"},{property:"name",direction:"ASC"}]});Ext.define("NX.s3blobstore.store.S3EncryptionType",{extend:"Ext.data.Store",model:"NX.s3blobstore.model.S3EncryptionType",proxy:{type:"direct",paramsAsHash:false,api:{read:"NX.direct.s3_S3.encryptionTypes"},reader:{type:"json",rootProperty:"data",successProperty:"success"}},sorters:[{property:"order",direction:"ASC"},{property:"name",direction:"ASC"}]});Ext.define("NX.s3blobstore.controller.S3Blobstore",{extend:"NX.wizard.Controller",stores:["NX.s3blobstore.store.S3Region","NX.s3blobstore.store.S3SignerType","NX.s3blobstore.store.S3EncryptionType"],models:["NX.s3blobstore.model.S3Region","NX.s3blobstore.model.S3SignerType","NX.s3blobstore.model.S3EncryptionType"],views:["NX.s3blobstore.view.BlobstoreSettings"]});
