Ext.define("NX.onboarding.app.PluginStrings",{"@aggregate_priority":90,singleton:true,requires:["NX.I18n"],keys:{Onboarding_Text:"Onboarding",Onboarding_Description:"Configuration changes requiring attention",Onboarding_Authenticate:"Your <b>admin</b> user password is located in <br><b>{0}</b> on the server.",Onboarding_LoadStepsError:"Failed to retrieve setup steps from server"},bundles:{"NX.onboarding.view.OnboardingStartScreen":{Title:"Setup",Description:"<p>This wizard will help you complete required setup tasks.</p>",},"NX.onboarding.view.OnboardingCompleteScreen":{Title:"Complete",Description:"<p>The setup tasks have been completed, enjoy using Nexus Repository Manager!</p>",Finish_Button:"Finish"},"NX.onboarding.view.ChangeAdminPasswordScreen":{Title:"Please choose a password for the admin user"},"NX.onboarding.view.ConfigureAnonymousAccessScreen":{Title:"Configure Anonymous Access",Description:'<p><b>Enable anonymous access</b> means that by default, users can search, browse and download  components from repositories without credentials. Please <b>consider the security implications for your  organization.</b><br><p><b>Disable anonymous access</b> should be chosen with care, as it <b>will require credentials for all</b> users and/or build tools.<br><br><a href="https://links.sonatype.com/products/nexus/anonymous-access/docs" target="_blank" rel="noopener">More information <span class="x-fa fa-external-link"></a></p>',Enable_Label:"Enable anonymous access",Disable_Label:"Disable anonymous access"},"NX.onboarding.view.ConfigureAnalyticsCollectionScreen":{Title:"Help Us Improve Nexus Repository",Description:"<p>Please help us improve the Nexus Repository experience and shape future feature improvements by sharing anonymous statistical metrics and performance information with Sonatype. The collected information will not contain identifying or proprietary information (e.g. the names of hosts, servers, repositories, or users).</p>",Enable_Label:"Yes, I agree to share anonymous data.",Disable_Label:"No, not interested."}}},function(a){NX.I18n.register(a)});Ext.define("NX.onboarding.app.PluginConfig",{"@aggregate_priority":100,requires:["NX.onboarding.app.PluginStrings"],controllers:[{id:"NX.onboarding.controller.Onboarding",active:function(){return NX.app.Application.bundleActive("org.sonatype.nexus.plugins.nexus-onboarding-plugin")}}]});Ext.define("NX.onboarding.view.OnboardingScreen",{extend:"NX.wizard.Screen",alias:"widget.nx-onboarding-screen",requires:["NX.Conditions","NX.I18n"],minHeight:250});Ext.define("NX.onboarding.view.ChangeAdminPasswordScreen",{extend:"NX.onboarding.view.OnboardingScreen",alias:"widget.nx-onboarding-change-admin-password-screen",requires:["NX.Conditions","NX.I18n"],initComponent:function(){var a=this;Ext.apply(a,{title:NX.I18n.render(a,"Title"),buttons:["back","->","next"],fields:[{xtype:"form",defaults:{anchor:"100%"},items:[{xtype:"nx-password",name:"password",itemId:"password",fieldLabel:NX.I18n.get("User_UserChangePassword_Password_FieldLabel"),allowBlank:false,listeners:{change:function(){var b=this;b.up("form").down("#verifyPassword").validate()}}},{xtype:"nx-password",itemId:"verifyPassword",fieldLabel:NX.I18n.get("User_UserChangePassword_PasswordConfirm_FieldLabel"),allowBlank:false,submitValue:false,validator:function(){var b=this;return(b.up("form").down("#password").getValue()===b.getValue())?true:NX.I18n.get("User_UserChangePassword_NoMatch_Error")}}]}]});a.callParent()}});Ext.define("NX.onboarding.model.Onboarding",{extend:"Ext.data.Model",idProperty:"type",fields:[{name:"type",type:"string",sortType:"asUCText"}]});Ext.define("NX.onboarding.store.Onboarding",{extend:"Ext.data.Store",model:"NX.onboarding.model.Onboarding",proxy:{type:"rest",url:"service/rest/internal/ui/onboarding"}});Ext.define("NX.onboarding.view.OnboardingCompleteScreen",{extend:"NX.onboarding.view.OnboardingScreen",alias:"widget.nx-onboarding-complete-screen",requires:["NX.Conditions","NX.I18n"],initComponent:function(){var a=this;Ext.apply(a,{title:NX.I18n.render(a,"Title"),description:NX.I18n.render(a,"Description"),buttons:["->",{text:NX.I18n.render(a,"Finish_Button"),action:"finish",ui:"nx-primary"}]});a.callParent()}});Ext.define("NX.onboarding.step.OnboardingCompleteStep",{extend:"NX.wizard.Step",requires:["NX.onboarding.view.OnboardingCompleteScreen"],config:{screen:"NX.onboarding.view.OnboardingCompleteScreen",enabled:true},init:function(){var a=this;a.control({"button[action=finish]":{click:a.finish}})}});Ext.define("NX.onboarding.view.OnboardingWizard",{extend:"NX.wizard.Panel",alias:"widget.nx-onboarding-wizard",requires:["NX.Conditions","NX.I18n"],minHeight:250});Ext.define("NX.onboarding.view.ConfigureAnonymousAccessScreen",{extend:"NX.onboarding.view.OnboardingScreen",alias:"widget.nx-onboarding-configure-anonymous-access-screen",requires:["NX.Conditions","NX.I18n"],initComponent:function(){var a=this;Ext.apply(a,{title:NX.I18n.render(a,"Title"),description:NX.I18n.render(a,"Description"),buttons:["back","->","next"],fields:[{xtype:"form",defaults:{anchor:"100%"},items:[{xtype:"radiogroup",allowBlank:false,columns:1,items:[{xtype:"radio",checked:false,boxLabel:NX.I18n.render(a,"Enable_Label"),name:"configureAnonymous",itemId:"anonymousEnabled"},{xtype:"radio",boxLabel:NX.I18n.render(a,"Disable_Label"),checked:false,name:"configureAnonymous",itemId:"anonymousDisabled"}]}]}]});a.callParent()}});Ext.define("NX.onboarding.step.ConfigureAnonymousAccessStep",{extend:"NX.wizard.Step",requires:["NX.onboarding.view.ConfigureAnonymousAccessScreen","NX.State"],config:{screen:"NX.onboarding.view.ConfigureAnonymousAccessScreen",enabled:true},init:function(){var a=this;a.control({"button[action=next]":{click:a.configureAnonymous},"button[action=back]":{click:a.moveBack}})},configureAnonymous:function(b){var c=this,a=b.up("form").down("#anonymousEnabled").getValue();NX.direct.coreui_AnonymousSettings.update({enabled:a,userId:"anonymous",realmName:"NexusAuthorizingRealm"},function(d){if(d&&d.success){c.moveNext()}})}});Ext.define("NX.onboarding.step.ChangeAdminPasswordStep",{extend:"NX.wizard.Step",requires:["NX.onboarding.view.ChangeAdminPasswordScreen","NX.State"],config:{screen:"NX.onboarding.view.ChangeAdminPasswordScreen",enabled:true},init:function(){var a=this;a.control({"button[action=next]":{click:a.changePassword},"button[action=back]":{click:a.moveBack}})},changePassword:function(b){var c=this,a=b.up("form").down("#password").getValue();Ext.Ajax.request({url:NX.util.Url.relativePath+"/service/rest/internal/ui/onboarding/change-admin-password",method:"PUT",params:a,success:function(){c.moveNext()},failure:function(d){var f;try{f=JSON.parse(d.responseText);if(Array.isArray(f)){f=f.map(function(h){return h.message}).join("\\n")}}catch(g){f=d.statusText}NX.Messages.error(f)}})}});Ext.define("NX.onboarding.view.OnboardingModal",{extend:"NX.view.ModalDialog",alias:"widget.nx-onboarding-modal",initComponent:function(){var a=this;Ext.apply(a,{header:false,closable:false,width:NX.view.ModalDialog.LARGE_MODAL,items:[{xtype:"nx-onboarding-wizard"}]});a.callParent();a.center()}});Ext.define("NX.onboarding.view.OnboardingStartScreen",{extend:"NX.onboarding.view.OnboardingScreen",alias:"widget.nx-onboarding-start-screen",requires:["NX.Conditions","NX.I18n"],initComponent:function(){var a=this;Ext.apply(a,{title:NX.I18n.render(a,"Title"),description:NX.I18n.render(a,"Description"),buttons:["->","next"]});a.callParent()}});Ext.define("NX.onboarding.step.OnboardingStartStep",{extend:"NX.wizard.Step",requires:["NX.onboarding.view.OnboardingStartScreen"],config:{screen:"NX.onboarding.view.OnboardingStartScreen",enabled:true},init:function(){var a=this;a.control({"button[action=next]":{click:a.moveNext}})}});Ext.define("NX.onboarding.controller.Onboarding",{extend:"NX.wizard.Controller",requires:["NX.Messages","NX.I18n","NX.onboarding.step.OnboardingStartStep","NX.onboarding.step.ChangeAdminPasswordStep","NX.onboarding.step.ConfigureAnonymousAccessStep","NX.onboarding.step.OnboardingCompleteStep","NX.State"],views:["OnboardingWizard","OnboardingStartScreen","ChangeAdminPasswordScreen","ConfigureAnonymousAccessScreen","OnboardingCompleteScreen","OnboardingModal"],stores:["Onboarding"],init:function(){var a=this;a.callParent();a.listen({component:{"nx-onboarding-wizard":{closed:a.reset},"nx-signin":{beforeshow:a.beforeShowSignin}},controller:{"#State":{changed:a.stateChanged,userAuthenticated:a.stateChanged}},store:{"#Onboarding":{load:a.itemsLoaded}}})},beforeShowSignin:function(d){var c=NX.State.getValue("onboarding.required"),a=NX.State.getValue("admin.password.file"),b=NX.I18n.format("Onboarding_Authenticate",Ext.htmlEncode(a));if(c&&a){d.addMessage(b)}else{d.clearMessage()}},stateChanged:function(){var b=NX.State.getValue("onboarding.required"),a=NX.State.getUser();if(b&&a&&a.administrator){this.loadItems()}},finish:function(){NX.State.setValue("onboarding.required",false);var a=Ext.ComponentQuery.query("nx-onboarding-modal");if(a&&a.length){a[0].close()}},loadItems:function(){var b=this,a=b.getStore("Onboarding");if(!a.isLoaded()&&!a.isLoading()){a.load()}},itemsLoaded:function(b,a,d){var c=this;c.registerStep("NX.onboarding.step.OnboardingStartStep");if(d&&Array.isArray(a)){a.forEach(function(e){c.registerStep("NX.onboarding.step."+e.get("type")+"Step")})}else{NX.Messages.error(NX.I18n.get("Onboarding_LoadStepsError"))}c.registerStep("NX.onboarding.step.OnboardingCompleteStep");Ext.widget("nx-onboarding-modal");c.load()}});
