/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * RutAuth Application strings
 *
 * @since 3.14
 */
Ext.define('NX.rutauth.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  /*
   * Note: Symbols follow the following naming convention:
   * <Class>_<Name>_<Component or Attribute>
   */

  keys: {
    Rut_Confirmation_Title: 'Please confirm',
    Rut_Confirmation_Html: '<p>{0}<br/><br/>Your credentials were verified using your Remote User Token. Proceed?</p>',
    Rut_Message_Default: 'This action required validation of your credentials.'
  }
}, function(obj) {
  NX.I18n.register(obj);
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * RutAuth plugin configuration.
 *
 * @since 3.14
 */
Ext.define('NX.rutauth.app.PluginConfig', {
  '@aggregate_priority': 100,

  requires: [
    'NX.rutauth.app.PluginStrings'
  ],

  controllers: [
    { id: 'NX.rutauth.controller.RutAuth',
      active: function () {
        return NX.app.Application.capabilityActive('rutauth');
      }
    }
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * RutAuth controller.
 *
 * @since 3.14
 */
Ext.define('NX.rutauth.controller.RutAuth', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Security',
    'NX.State',
    'Ext.Deferred'
  ],

  CONTINUE_PROCESSING: true,

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.listen({
      controller: {
        '#User': {
          authRequest: me.rutAuth,
          authTokenRequest: me.rutAuthToken
        }
      }
    });
  },

  /**
   * Attempts to authenticate the current user with their RUT if the capability is active. In the event RUT auth is
   * enabled, but fails, the method will check for a default function argument and execute it
   *
   * @private
   * @returns {boolean} true if auth won't be performed, false otherwise
   */
  rutAuth: function(handlers) {
    var me = this,
        handler = new Ext.Deferred();

    //<if debug>
//    me.logDebug('RUT auth capability enabled; attempting to authenticate with RUT');
    //</if>

    NX.direct.rut_Auth.authenticate(function(response) {
      if (Ext.isObject(response) && response.success && !!response.data) {
        //<if debug>
//        me.logDebug('RUT authentication successful.');
        //</if>

        NX.direct.rapture_Security.getUser(function(response) {
          if (Ext.isObject(response) && response.success) {
            handler.resolve(response.data);
          }
          else {
            handler.resolve();
          }
        });
      }
      else {
        handler.resolve();
      }
    });

    if (Ext.isArray(handlers)) {
      handlers.push(handler);
    }

    return me.CONTINUE_PROCESSING;
  },

  rutAuthToken: function(handlers, message) {
    var me = this,
        handler = new Ext.Deferred();

    //<if debug>
//    me.logDebug('RUT auth capability enabled; attempting to retrieve auth token using RUT');
    //</if>

    NX.direct.rut_Auth.authToken(function(response) {
      if (Ext.isObject(response) && response.success && response.data) {
        //<if debug>
//        me.logDebug('Successfully obtained auth token using RUT');
        //</if>
        var confirmMsg = (message || NX.I18n.get('Rut_Message_Default'));

        // display a confirmation since we are not asking the user for credentials
        Ext.Msg.confirm(
            NX.I18n.get('Rut_Confirmation_Title'),
            NX.I18n.format('Rut_Confirmation_Html', confirmMsg),
            function(btn) {
              if (btn === 'yes' || btn === 'ok') {
                handler.resolve(response.data);
              }
              else {
                handler.reject();
              }
            }
        );
      }
      else {
        //<if debug>
//        me.logDebug('Unable to obtain auth token using RUT');
        //</if>

        handler.resolve();
      }
    });

    if (Ext.isArray(handlers)) {
      handlers.push(handler);
    }

    return me.CONTINUE_PROCESSING;
  }
});

