/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * SAML Application strings
 *
 * @since 3.22
 */
Ext.define('NX.saml.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  keys: {
    SAML_SignIn_SSO: 'Sign In with SSO',
    SAML_SignIn_Local: 'Sign In without SSO'
  }
}, function(obj) {
  NX.I18n.register(obj);
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * SAML plugin configuration.
 *
 * @since 3.22
 */
Ext.define('NX.saml.app.PluginConfig', {
  '@aggregate_priority': 100,

  requires: [
    'NX.saml.app.PluginStrings'
  ],

  controllers: [
    {
      id: 'NX.saml.controller.SamlAuth',
      active: function() {
        return NX.State.getValue("samlEnabled", false);
      }
    }
  ]
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Sign-in window.
 *
 * @since 3.22
 */
Ext.define('NX.saml.view.SamlSignInWindow', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-saml-signin',
  requires: [
    'NX.I18n'
  ],

  ui: 'nx-inset',

  initComponent: function() {
    this.title = NX.I18n.get('SignIn_Title');
    this.width = NX.view.ModalDialog.SMALL_MODAL;

    this.items = [
      {
        layout: {
          type: 'vbox',
          align: 'middle'
        },
        defaults: {
          margin: { bottom: 10 }
        },
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('SAML_SignIn_SSO'),
            ui: 'nx-primary',
            action: 'signInWithSso'
          },
          {
            xtype: 'button',
            text: NX.I18n.get('SAML_SignIn_Local'),
            scale: 'small',
            action: 'signInLocally'
          }
        ]
      }
    ];

    this.callParent();
  }
});

/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX, axios*/

/**
 * SamlAuth controller.
 *
 * @since 3.22
 */
Ext.define('NX.saml.controller.SamlAuth', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.State',
    'NX.saml.view.SamlSignInWindow'
  ],

  listen: {
    controller: {
      '#User': {
        beforeauthenticate: 'authenticate',
        beforereauthenticate: 'reauthenticate',
        authTokenRequest: 'authTokenRequest'
      },
    },
    component: {
      'button[action=signInWithSso]': {
        click: 'doSamlSignin',
      },
      'button[action=signInLocally]': {
        click: 'doLocalSignin'
      }
    }
  },

  refs: [
    {
      ref: 'samlSignInWindow',
      selector: 'nx-saml-signin'
    }
  ],

  views: [
      'SamlSignInWindow'
  ],

  showLocalSignInWindow: undefined,

  /**
   * Handles the beforeauthenticate event
   * @param showLocalSignInWindow - a callback function to call when clicking on the "login without sso" button
   */
  authenticate: function(showLocalSignInWindow) {
    if (!NX.State.getValue('samlEnabled', false)) {
      console.debug('saml not enabled, showing regular login dialog');
      return true;
    }

    this.showLocalSignInWindow = showLocalSignInWindow;
    this.getSamlSignInWindowView().create();

    return false;
  },

  /**
   * Handles the beforereauthenticate event to skip showing the reauthenticate dialog for SAML users
   */
  reauthenticate: function() {
    var authenticatedRealms = NX.State.getUser().authenticatedRealms || [];
    if (Ext.Array.contains(authenticatedRealms, 'SamlRealm')) {
      console.warn('SAML user attempted to access a feature they have no permissions for, skip reauthentication');
      return false;
    }
  },

  /**
   * Add a new authTokenHandler and resolve it from a backend request if the user is a SAML user
   */
  authTokenRequest: function(handlers) {
    var deferred = new Ext.Deferred(),
        authenticatedRealms = NX.State.getUser().authenticatedRealms || [];

    if (Ext.Array.contains(authenticatedRealms, 'SamlRealm')) {
      axios.get('/service/rest/internal/ui/saml/authToken').then(function(response) {
        deferred.resolve(response.data);
      });
      if (Ext.isArray(handlers)) {
        handlers.push(deferred);
      }
    }

    return true;
  },

  doSamlSignin: function() {
    window.location.href = 'saml';
  },

  doLocalSignin: function() {
    this.getSamlSignInWindow().close();
    this.showLocalSignInWindow();
  }
});

