/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Sign-in window.
 *
 * @since 3.22
 */
Ext.define('NX.saml.view.SamlSignInWindow', {
  extend: 'NX.view.ModalDialog',
  alias: 'widget.nx-saml-signin',
  requires: [
    'NX.I18n'
  ],

  ui: 'nx-inset',

  initComponent: function() {
    this.title = NX.I18n.get('SignIn_Title');
    this.width = NX.view.ModalDialog.SMALL_MODAL;

    this.items = [
      {
        layout: {
          type: 'vbox',
          align: 'middle'
        },
        defaults: {
          margin: { bottom: 10 }
        },
        items: [
          {
            xtype: 'button',
            text: NX.I18n.get('SAML_SignIn_SSO'),
            ui: 'nx-primary',
            action: 'signInWithSso'
          },
          {
            xtype: 'button',
            text: NX.I18n.get('SAML_SignIn_Local'),
            scale: 'small',
            action: 'signInLocally'
          }
        ]
      }
    ];

    this.callParent();
  }
});
