/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.raw.internal.orient;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.raw.internal.orient.RawRestoreBlobData;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.orient.raw.RawContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@Named(value="raw")
@Priority(value=0x7FFFFFFF)
@Singleton
public class OrientRawRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<RawRestoreBlobData> {
    private final AttributesMap NO_CONTENT_ATTRIBUTES = null;

    @Inject
    public OrientRawRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
    }

    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.MD5);
    }

    protected RawRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return new RawRestoreBlobData(blobData);
    }

    protected boolean canAttemptRestore(RawRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        if (!repository.optionalFacet(RawContentFacet.class).isPresent()) {
            this.log.warn("Skipping as Raw Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(RawRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    protected boolean assetExists(RawRestoreBlobData data) {
        return this.getRawContentFacet(data).assetExists(data.getBlobData().getBlobName());
    }

    protected void createAssetFromBlob(AssetBlob assetBlob, RawRestoreBlobData data) {
        this.getRawContentFacet(data).put(this.getAssetPath(data), assetBlob, this.NO_CONTENT_ATTRIBUTES);
    }

    private RawContentFacet getRawContentFacet(RawRestoreBlobData data) {
        return (RawContentFacet)data.getBlobData().getRepository().facet(RawContentFacet.class);
    }

    protected boolean componentRequired(@Nonnull RawRestoreBlobData data) throws IOException {
        return true;
    }

    protected Query getComponentQuery(@Nonnull RawRestoreBlobData data) {
        return Query.builder().where("name").eq((Object)data.getBlobData().getBlobName()).build();
    }

    protected Repository getRepository(@Nonnull RawRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }
}

