/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.raw.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.content.raw.RawContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@Named(value="raw")
@FeatureFlag(name="nexus.datastore.enabled")
@Singleton
public class RawRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    public RawRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (repository.optionalFacet(RawContentFacet.class).isPresent()) {
            return true;
        }
        this.log.warn("Skipping as Raw Facet not found on repository: {}", (Object)repository.getName());
        return false;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        RawContentFacet rawContentFacet = (RawContentFacet)data.getRepository().facet(RawContentFacet.class);
        rawContentFacet.put(data.getBlobName(), (Payload)new DetachedBlobPayload(assetBlob));
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        return true;
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

