/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.sonatype.gossip.Event;
import org.sonatype.gossip.Level;
import org.sonatype.gossip.LoggerDelegateFactory;
import org.sonatype.gossip.LoggerSupport;
import org.sonatype.gossip.render.PatternRenderer;
import org.sonatype.gossip.render.Renderer;

public final class Log {
    private static final Map<String, LoggerDelegateFactory.LoggerDelegateAware> delegates = new HashMap<String, LoggerDelegateFactory.LoggerDelegateAware>();
    private static final String INTERNAL_PREFIX = "org.sonatype.gossip";
    private static volatile Level threshold;
    private static final Level internalThreshold;
    private static volatile Renderer renderer;
    private static volatile PrintStream stream;
    private static boolean configured;
    private static ILoggerFactory configuredFactory;

    public static Level getThreshold() {
        return threshold;
    }

    public static void setThreshold(Level threshold) {
        if (threshold == null) {
            throw new NullPointerException();
        }
        Log.threshold = threshold;
    }

    public static Renderer getRenderer() {
        return renderer;
    }

    public static void setRenderer(Renderer renderer) {
        if (renderer == null) {
            throw new NullPointerException();
        }
        Log.renderer = renderer;
    }

    public static PrintStream getStream() {
        return stream;
    }

    public static void setStream(PrintStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        Log.stream = stream;
    }

    public static synchronized void configure(ILoggerFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        if (!configured) {
            configuredFactory = factory;
            for (Map.Entry<String, LoggerDelegateFactory.LoggerDelegateAware> entry : delegates.entrySet()) {
                Logger logger = configuredFactory.getLogger(entry.getKey());
                entry.getValue().setDelegate(logger);
            }
            delegates.clear();
            configured = true;
        }
    }

    public static synchronized Logger getLogger(String name) {
        assert (name != null);
        if (name.startsWith(INTERNAL_PREFIX)) {
            return new LoggerImpl(name);
        }
        if (!configured) {
            Logger delegate = LoggerDelegateFactory.create(new LoggerImpl(name));
            delegates.put(name, (LoggerDelegateFactory.LoggerDelegateAware)delegate);
            return delegate;
        }
        return configuredFactory.getLogger(name);
    }

    public static Logger getLogger(Class type) {
        assert (type != null);
        return Log.getLogger(type.getName());
    }

    static {
        String baseName = Log.class.getName();
        String thresholdName = System.getProperty(baseName + ".threshold");
        threshold = thresholdName != null ? Level.valueOf(thresholdName.toUpperCase()) : Level.WARN;
        String internalThresholdName = System.getProperty(baseName + ".internalThreshold");
        internalThreshold = internalThresholdName != null ? Level.valueOf(internalThresholdName.toUpperCase()) : Level.WARN;
        PatternRenderer renderer = new PatternRenderer();
        String pattern = System.getProperty(baseName + ".pattern", "[%l] %c - %m%n%x");
        renderer.setPattern(pattern);
        Log.renderer = renderer;
        StreamType streamType = StreamType.OUT;
        String streamName = System.getProperty(baseName + ".stream");
        if (streamName != null) {
            streamType = StreamType.valueOf(streamName.toUpperCase());
        }
        switch (streamType) {
            case ERR: {
                stream = System.err;
                break;
            }
            default: {
                stream = System.out;
            }
        }
    }

    private static class LoggerImpl
    extends LoggerSupport {
        private LoggerImpl(String name) {
            super(name);
        }

        protected boolean isEnabled(Level l) {
            assert (l != null);
            Level threshold = Log.getThreshold();
            if (this.getName().startsWith(Log.INTERNAL_PREFIX)) {
                threshold = internalThreshold;
            }
            return threshold.id <= l.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doLog(Event event) {
            PrintStream out;
            PrintStream printStream = out = Log.getStream();
            synchronized (printStream) {
                out.print(Log.getRenderer().render(event));
                out.flush();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StreamType {
        OUT,
        ERR;

    }
}

