/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.nuget.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.blobstore.restore.nuget.internal.orient.NugetRestoreBlobData;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.NugetRestoreBlobType;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetRestoreFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.util.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;

@FeatureFlag(name="nexus.orient.enabled")
@Priority(value=0x7FFFFFFF)
@Named(value="nuget")
@Singleton
public class OrientNugetRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<NugetRestoreBlobData> {
    private final Clock clock = new Clock();

    @Inject
    public OrientNugetRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
    }

    protected NugetRestoreBlobData createRestoreData(RestoreBlobData restoreBlobData) {
        Preconditions.checkState((!StringUtils.isEmpty((String)restoreBlobData.getBlobName()) ? 1 : 0) != 0, (Object)"Blob name cannot be empty");
        HashMap<String, String> metadata = new HashMap<String, String>();
        NugetRestoreBlobType assetKind = this.getNugetRestoreAssetKind(restoreBlobData);
        if (assetKind == NugetRestoreBlobType.V2_BLOB_PACKAGE) {
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (InputStream is = restoreBlobData.getBlob().getInputStream();){
                    metadata.putAll(NugetPackageUtils.packageMetadata((InputStream)is));
                    OrientNugetRestoreBlobStrategy.addCreationTime(this.clock.millis(), metadata);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NugetPackageException | IOException throwable) {
                this.log.warn("Unable to load metadata from {}.", (Object)restoreBlobData.getBlobName());
            }
        }
        return new NugetRestoreBlobData(restoreBlobData, metadata, assetKind);
    }

    private NugetRestoreBlobType getNugetRestoreAssetKind(RestoreBlobData restoreBlobData) {
        String blobType = restoreBlobData.getProperty("@BlobStore.content-type");
        if (NugetPackageUtils.isV3Metadata((String)restoreBlobData.getBlobName())) {
            return NugetRestoreBlobType.V3_BLOB_METADATA;
        }
        if (NugetPackageUtils.isV3Package((String)blobType)) {
            return NugetRestoreBlobType.V3_BLOB_PACKAGE;
        }
        return NugetRestoreBlobType.V2_BLOB_PACKAGE;
    }

    private static void addCreationTime(long milliseconds, Map<String, String> metadata) {
        String timeStamp = ODataFeedUtils.datetime((long)milliseconds);
        metadata.put("CREATED", timeStamp);
        metadata.put("LASTUPDATED", timeStamp);
        metadata.put("PUBLISHED", timeStamp);
    }

    protected boolean canAttemptRestore(@Nonnull NugetRestoreBlobData nugetRestoreBlobData) {
        Repository repository = this.getRepository(nugetRestoreBlobData);
        Optional nugetRestoreFacetFacet = repository.optionalFacet(OrientNugetRestoreFacet.class);
        if (!nugetRestoreFacetFacet.isPresent()) {
            this.log.warn("Skipping as Nuget Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull NugetRestoreBlobData nugetRestoreBlobData) {
        return nugetRestoreBlobData.getBlobData().getBlobName();
    }

    protected boolean assetExists(@Nonnull NugetRestoreBlobData nugetRestoreBlobData) {
        OrientNugetRestoreFacet facet = this.getRestoreFacet(nugetRestoreBlobData);
        return facet.assetExists(this.getAssetPath(nugetRestoreBlobData));
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull NugetRestoreBlobData nugetRestoreBlobData) throws IOException {
        OrientNugetRestoreFacet facet = this.getRestoreFacet(nugetRestoreBlobData);
        String assetPath = this.getAssetPath(nugetRestoreBlobData);
        facet.restore(assetBlob, assetPath, nugetRestoreBlobData.getMetadata(), nugetRestoreBlobData.getRestoreBlobType());
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.SHA512);
    }

    protected boolean componentRequired(NugetRestoreBlobData data) {
        return data.getRestoreBlobType() != NugetRestoreBlobType.V3_BLOB_METADATA;
    }

    protected Query getComponentQuery(NugetRestoreBlobData data) {
        OrientNugetRestoreFacet facet = this.getRestoreFacet(data);
        RestoreBlobData blobData = data.getBlobData();
        NugetPackageCoords packageIdAndVersion = facet.getPackageIdAndVersionFromPath(blobData.getBlobName(), data.getMetadata());
        return facet.getComponentQuery(packageIdAndVersion);
    }

    protected Repository getRepository(@Nonnull NugetRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    private OrientNugetRestoreFacet getRestoreFacet(@Nonnull NugetRestoreBlobData nugetRestoreBlobData) {
        Repository repository = this.getRepository(nugetRestoreBlobData);
        return (OrientNugetRestoreFacet)repository.facet(OrientNugetRestoreFacet.class);
    }
}

