/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.nuget.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.datastore.ContentNugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.HostedType;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="nuget")
@Singleton
public class NugetRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private final RepositoryManager repositoryManager;

    @Inject
    public NugetRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (repository.optionalFacet(ContentFacet.class).isPresent()) {
            return true;
        }
        this.log.warn("Skipping as Content Facet not found on repository: {}", (Object)repository.getName());
        return false;
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        return NugetPackageUtils.isV3Package((String)data.getBlobType()) || data.getBlobType().equals("application/zip");
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        block22: {
            String assetPath = this.getAssetPath(data);
            Repository repository = data.getRepository();
            Throwable throwable = null;
            Object var6_7 = null;
            try (DetachedBlobPayload payload = new DetachedBlobPayload(data.getBlob());){
                if (this.isComponentRequired(data)) {
                    NugetPackageCoords nugetCoords = this.getPackageIdAndVersionFromPath(assetPath);
                    if (repository.getType() instanceof HostedType) {
                        this.restoreHostedPackage(repository, (Payload)payload);
                    } else if (repository.getType() instanceof ProxyType) {
                        this.restoreProxyPackage(repository, (Payload)payload, nugetCoords);
                    }
                    break block22;
                }
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (Content content = new Content((Payload)payload);){
                    this.restoreMetadata(assetPath, repository, content);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private void restoreMetadata(String assetPath, Repository repository, Content content) {
        ((NugetContentFacet)repository.facet(NugetContentFacet.class)).putMetadata(assetPath, (Payload)content);
    }

    private void restoreProxyPackage(Repository repository, Payload payload, NugetPackageCoords nugetCoords) {
        ((NugetContentFacet)repository.facet(NugetContentFacet.class)).putPackage(nugetCoords.getId(), nugetCoords.getVersion(), payload);
    }

    private void restoreHostedPackage(Repository repository, Payload payload) throws IOException {
        ContentNugetV3HostedFacet nugetV3HostedFacet = (ContentNugetV3HostedFacet)repository.facet(ContentNugetV3HostedFacet.class);
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = contentFacet.blobs().ingest(payload, (Iterable)NugetPackageUtils.HASH_ALGORITHMS);){
            Map<String, String> metadata = this.getMetadata(tempBlob.getBlob());
            nugetV3HostedFacet.put(metadata, tempBlob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> getMetadata(Blob blob) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream in = blob.getInputStream();){
                return NugetPackageUtils.packageMetadata((InputStream)in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException nugetPackageException) {
            this.log.warn("Skipping invalid NuGet package blob: {}", (Object)blob.getId());
            return Collections.emptyMap();
        }
    }

    private NugetPackageCoords getPackageIdAndVersionFromPath(String path) {
        Map parsedPath = new TokenParser("/{id}/{version}").parse(path);
        if (parsedPath != null) {
            String id = (String)parsedPath.get("id");
            String version = (String)parsedPath.get("version");
            return new NugetPackageCoords(id, version);
        }
        throw new IllegalArgumentException(path);
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

