/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.nuget.internal;

import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.restore.datastore.DefaultIntegrityCheckStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.IntegrityCheckStrategy;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.content.Asset;

@Named(value="nuget")
@Singleton
@FeatureFlag(name="nexus.datastore.enabled")
public class NugetIntegrityCheckStrategy
extends DefaultIntegrityCheckStrategy
implements IntegrityCheckStrategy {
    static final String BAD_FORMAT = "Asset name '%s' not in expected Nuget format of 'name/version'";

    @Inject
    public NugetIntegrityCheckStrategy(@Named(value="${nexus.blobstore.restore.integrityCheck.batchSize:-1000}") int browseBatchSize) {
        super(browseBatchSize);
    }

    protected String getAssetName(Asset asset) {
        String assetPath = asset.path();
        if (NugetPackageUtils.isV3Metadata((String)assetPath)) {
            return assetPath;
        }
        String assetPathFromComponent = asset.component().map(component -> String.valueOf('/') + component.name() + '/' + component.version()).orElseThrow(() -> new RuntimeException("Component not found for asset " + asset.path()));
        if (!StringUtils.equalsIgnoreCase((CharSequence)assetPath, (CharSequence)assetPathFromComponent)) {
            throw new IllegalArgumentException(String.format(BAD_FORMAT, assetPath));
        }
        return assetPath;
    }

    protected String getBlobName(BlobAttributes blobAttributes) {
        return blobAttributes.getProperties().getProperty("@BlobStore.blob-name");
    }
}

