/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.sonatype.nexus.distributed.internal.event.DistributedEventMixin;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.mybatis.AbstractRawJsonTypeHandler;
import org.sonatype.nexus.distributed.event.service.api.DistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.AuthorizationChangedDistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.BlobStoreDistributedConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.DataStoreConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.JWTSecretChangedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.PrivilegeConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryCacheInvalidationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RepositoryRemoteConnectionStatusEvent;
import org.sonatype.nexus.distributed.event.service.api.common.RoleConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.SelectorConfigurationChangedEvent;

@Named
@Singleton
public class DistributedEventTypeHandler
extends AbstractRawJsonTypeHandler<DistributedEvent> {
    private static final ObjectMapper RAW_OBJECT_MAPPER = new ObjectMapper();

    protected ObjectMapper buildObjectMapper(Supplier<ObjectMapper> unused) {
        RAW_OBJECT_MAPPER.addMixIn(DistributedEvent.class, DistributedEventMixin.class);
        this.registerRepositoryConfigurationEvent();
        this.registerPrivilegeConfigurationEvent();
        this.registerBlobStoreConfigurationEvent();
        this.registerRoleConfigurationEvent();
        this.registerDataStoreConfigurationEvent();
        this.registerAuthorizationChangedDistributedEvent();
        this.registerJWTSecretChangedEvent();
        this.registerRepositoryCacheEvent();
        this.registerRepositoryBlockStateChangedConfigurationEvent();
        this.registerSelectorConfigurationChangedEvent();
        return RAW_OBJECT_MAPPER;
    }

    private void registerRepositoryConfigurationEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(RepositoryConfigurationEvent.class, "RepositoryConfigurationEvent")});
    }

    private void registerPrivilegeConfigurationEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(PrivilegeConfigurationEvent.class, "PrivilegeConfigurationEvent")});
    }

    private void registerBlobStoreConfigurationEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(BlobStoreDistributedConfigurationEvent.class, "BlobStoreConfigurationEvent")});
    }

    private void registerRoleConfigurationEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(RoleConfigurationEvent.class, "RoleConfigurationEvent")});
    }

    private void registerDataStoreConfigurationEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(DataStoreConfigurationEvent.class, "DataStoreConfigurationEvent")});
    }

    private void registerAuthorizationChangedDistributedEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(AuthorizationChangedDistributedEvent.class, "AuthorizationChangedDistributedEvent")});
    }

    private void registerJWTSecretChangedEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(JWTSecretChangedEvent.class, "JWTSecretChangedEvent")});
    }

    private void registerRepositoryCacheEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(RepositoryCacheInvalidationEvent.class, "RepositoryCacheInvalidationEvent")});
    }

    private void registerRepositoryBlockStateChangedConfigurationEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(RepositoryRemoteConnectionStatusEvent.class, "RepositoryRemoteConnectionStatusEvent")});
    }

    private void registerSelectorConfigurationChangedEvent() {
        RAW_OBJECT_MAPPER.registerSubtypes(new NamedType[]{new NamedType(SelectorConfigurationChangedEvent.class, "SelectorConfigurationChangedEvent")});
    }
}

