/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.event.DistributedEventStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.distributed.event.service.api.common.PublisherEvent;

@Named
@Singleton
public class DistributedEventPublisher
extends ComponentSupport
implements EventAware {
    private final DistributedEventStore store;
    private final NodeAccess nodeAccess;

    @Inject
    public DistributedEventPublisher(DistributedEventStore store, NodeAccess nodeAccess) {
        this.store = (DistributedEventStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(PublisherEvent event) {
        this.log.debug("Source node: {}, publishing {}", (Object)this.nodeAccess.getId(), (Object)event.getDistributedEvent());
        this.store.publishEvent(this.nodeAccess.getId(), event);
    }
}

