/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.event.DistributedEventData;
import com.sonatype.nexus.distributed.event.DistributedEventStore;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class DistributedEventProducer
extends LifecycleSupport
implements EventAware {
    private static final int EVENT_FETCH_LIMIT = Integer.MAX_VALUE;
    private final int eventFetchInterval;
    private final DistributedEventStore store;
    private final EventManager eventManager;
    private final PeriodicJobService periodicJobService;
    private final NodeAccess nodeAccess;
    private final OffsetDateTime nodeStartTime = OffsetDateTime.now(ZoneOffset.UTC);
    private PeriodicJobService.PeriodicJob publisherTask;
    private String continuationToken;

    @Inject
    public DistributedEventProducer(DistributedEventStore store, EventManager eventManager, PeriodicJobService periodicJobService, @Named(value="${nexus.distributed.events.fetch.interval.seconds:-5}") int eventFetchIntervalSeconds, @Named NodeAccess nodeAccess) {
        this.store = (DistributedEventStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        Preconditions.checkState((eventFetchIntervalSeconds >= 0 ? 1 : 0) != 0, (Object)"Event fetch interval should be positive");
        this.eventFetchInterval = eventFetchIntervalSeconds;
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting DES events polling");
        this.periodicJobService.startUsing();
        this.publisherTask = this.periodicJobService.schedule(this::readDESEvents, this.eventFetchInterval);
    }

    protected void doStop() throws Exception {
        this.publisherTask.cancel();
        this.periodicJobService.stopUsing();
    }

    public void readDESEvents() {
        Continuation<DistributedEventData> continuationEvents = this.store.readRemoteEvents(this.nodeAccess.getId(), Integer.MAX_VALUE, this.continuationToken, this.nodeStartTime);
        if (CollectionUtils.isNotEmpty(continuationEvents)) {
            this.continuationToken = continuationEvents.nextContinuationToken();
            continuationEvents.forEach(event -> this.eventManager.post((Object)event.getEventData()));
        }
    }
}

