/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.event.DistributedEventStore;
import java.time.Duration;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class DistributedEventCleanupJobManager
extends StateGuardLifecycleSupport {
    private final PeriodicJobService periodicJobService;
    private final DistributedEventStore distributedEventStore;
    private final int minutesAgo;
    private Optional<PeriodicJobService.PeriodicJob> job = Optional.empty();

    @Inject
    public DistributedEventCleanupJobManager(PeriodicJobService periodicJobService, DistributedEventStore distributedEventStore, @Named(value="${nexus.distributed.events.minutesAgo:-60}") int minutesAgo) {
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.distributedEventStore = (DistributedEventStore)((Object)Preconditions.checkNotNull((Object)((Object)distributedEventStore)));
        Preconditions.checkArgument((minutesAgo > 0 ? 1 : 0) != 0, (Object)"nexus.distributed.events.minutesAgo must be larger than 0");
        this.minutesAgo = minutesAgo;
    }

    protected void doStart() throws Exception {
        this.periodicJobService.startUsing();
        this.job = Optional.of(this.periodicJobService.schedule(this::cleanupOldEvents, Duration.ofMinutes(this.minutesAgo)));
    }

    protected void doStop() throws Exception {
        this.job.ifPresent(PeriodicJobService.PeriodicJob::cancel);
        this.periodicJobService.stopUsing();
    }

    protected void cleanupOldEvents() {
        try {
            this.distributedEventStore.cleanupOldEvents(this.minutesAgo);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Failed to remove old distributed events", (Throwable)e);
            }
            this.log.warn("Failed to remove old distributed events: {}", (Object)e.getMessage());
        }
    }
}

