/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.cooperation;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.cooperation.CooperationLock;
import com.sonatype.nexus.distributed.internal.cooperation.DistributedCooperationRegistry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Optional;
import org.sonatype.nexus.common.cooperation2.Config;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.CooperationException;
import org.sonatype.nexus.common.cooperation2.IOCall;
import org.sonatype.nexus.common.cooperation2.IOCheck;
import org.sonatype.nexus.common.cooperation2.ScopedCooperation2Support;

public class DistributedCooperation2
extends ScopedCooperation2Support {
    private static final int CHECK_PERIOD_MILLIS = 500;
    private final DistributedCooperationRegistry distributedCooperationRegistry;
    private final Duration clusteredCooperationLag;
    private final Duration distributedTimeout;
    private final int retryCount;

    public DistributedCooperation2(String scope, Config config, int retryCount, Duration distributedTimeout, Duration clusteredCooperationLag, DistributedCooperationRegistry distributedCooperationRegistry) {
        super(scope, config);
        Preconditions.checkArgument((retryCount > -1 ? 1 : 0) != 0, (Object)("Retry count must be zero or greater, found: " + retryCount));
        this.retryCount = retryCount;
        this.distributedTimeout = (Duration)Preconditions.checkNotNull((Object)distributedTimeout);
        this.clusteredCooperationLag = (Duration)Preconditions.checkNotNull((Object)clusteredCooperationLag);
        this.distributedCooperationRegistry = (DistributedCooperationRegistry)Preconditions.checkNotNull((Object)distributedCooperationRegistry);
    }

    public <RET> Cooperation2.Builder<RET> on(IOCall<RET> workFunction) {
        return new DistributedCooperation2Builder(workFunction);
    }

    protected <T> Optional<T> join(IOCheck<T> request) throws IOException {
        int frequency = (int)this.clusteredCooperationLag.toMillis() / 500;
        if (frequency <= 1) {
            return request.check();
        }
        int i = 0;
        while (i < frequency) {
            Optional value = request.check();
            if (value.isPresent()) {
                return value;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        return Optional.empty();
    }

    private class DistributedCooperation2Builder<R>
    extends ScopedCooperation2Support.ScopedCooperation2Builder<R> {
        private DistributedCooperation2Builder(IOCall<R> workFunction) {
            super((ScopedCooperation2Support)DistributedCooperation2.this, workFunction);
        }

        private R maybePerform(String failureMessage) throws IOException {
            String key = this.cooperationKey.getKey();
            DistributedCooperation2.this.log.debug("[{}]: {}", (Object)key, (Object)failureMessage);
            if (this.performWorkOnFail) {
                DistributedCooperation2.this.log.debug("Proceeding with local evaluation for {} despite failure", (Object)key);
                return (R)this.workFunction.call();
            }
            throw new CooperationException(failureMessage);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected R perform(Boolean failover, Duration remainingTimeout, int retries) {
            try {
                Optional potentialResult;
                if (retries == 0) {
                    this.maybePerform("Retry limit exceeded");
                } else if (remainingTimeout.isNegative()) {
                    this.maybePerform("Remote timeout exceeded");
                }
                if (failover.booleanValue() && (potentialResult = this.checkFunction.check()).isPresent()) {
                    return (R)potentialResult.get();
                }
                String key = this.cooperationKey.getHashedKey();
                CooperationLock lock = DistributedCooperation2.this.distributedCooperationRegistry.lockCooperationKey(key, DistributedCooperation2.this.distributedTimeout);
                if (lock.isAcquired()) {
                    try {
                        Object object = this.workFunction.call();
                        return (R)object;
                    }
                    finally {
                        DistributedCooperation2.this.distributedCooperationRegistry.releaseCooperationKey(key);
                    }
                }
                int frequency = (int)remainingTimeout.toMillis() / 500;
                int i = 0;
                while (true) {
                    if (i >= frequency) {
                        return this.maybePerform("Remote timeout exceeded");
                    }
                    if (DistributedCooperation2.this.distributedCooperationRegistry.canLockCooperationKey(key)) {
                        DistributedCooperation2.this.log.debug("Distributed lock released");
                        Optional result = DistributedCooperation2.this.join(this.checkFunction);
                        if (result.isPresent()) {
                            return (R)result.get();
                        }
                        DistributedCooperation2.this.log.debug("Result not found after distributed lock release");
                        return this.perform(true, remainingTimeout.minusMillis(i * 500), --retries);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    ++i;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        protected R perform(Boolean failover) {
            return this.perform(failover, DistributedCooperation2.this.distributedTimeout, DistributedCooperation2.this.retryCount);
        }
    }
}

