/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.node.datastore.NodeIdStore;

@Singleton
@Priority(value=0x7FFFFFFF)
@Named(value="ephemeral")
public class EphemeralNodeAccess
extends StateGuardLifecycleSupport
implements NodeAccess {
    public static final String EPHEMERAL_NODE_ACCESS = "ephemeral";
    private static final String NODE_ID = UUID.randomUUID().toString();
    private Map<String, String> memberAliases = Collections.emptyMap();
    private final NodeIdStore nodeIdStore;

    @Inject
    public EphemeralNodeAccess(NodeIdStore nodeIdStore) {
        this.nodeIdStore = (NodeIdStore)Preconditions.checkNotNull((Object)nodeIdStore);
    }

    protected void doStart() {
        this.memberAliases = ImmutableMap.of((Object)NODE_ID, (Object)NODE_ID);
    }

    @Guarded(by={"STARTED"})
    public String getId() {
        return NODE_ID;
    }

    public boolean isClustered() {
        return true;
    }

    @Guarded(by={"STARTED"})
    public String getClusterId() {
        return this.nodeIdStore.getOrCreate();
    }

    public boolean isOldestNode() {
        return true;
    }

    public Set<String> getMemberIds() {
        return Collections.singleton(NODE_ID);
    }

    public Map<String, String> getMemberAliases() {
        return this.memberAliases;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "id='" + NODE_ID + '\'' + '}';
    }
}

