/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.cooperation;

import com.sonatype.nexus.distributed.cooperation.CooperationLock;
import com.sonatype.nexus.distributed.internal.cooperation.store.CooperationDAO;
import com.sonatype.nexus.distributed.internal.cooperation.store.CooperationLockData;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class CooperationStore
extends ConfigStoreSupport<CooperationDAO> {
    @Inject
    public CooperationStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Transactional
    public void lockCooperationKey(CooperationLockData data) {
        ((CooperationDAO)this.dao()).insertCooperationLock(data);
    }

    @Transactional
    public Optional<CooperationLock> readCooperationLock(String cooperationKey) {
        return ((CooperationDAO)this.dao()).readCooperationLock(cooperationKey);
    }

    @Transactional
    public int reassignExpiredCooperationKeyLock(CooperationLockData data) {
        return ((CooperationDAO)this.dao()).reassignExpiredCooperationLock(data);
    }

    @Transactional
    public int releaseCooperationKey(String cooperationKey, String nodeId) {
        return ((CooperationDAO)this.dao()).removeCooperationLock(cooperationKey, nodeId);
    }

    @Transactional
    public boolean canAcquireLock(String cooperationKey, String nodeId) {
        return !((CooperationDAO)this.dao()).isActiveCooperation(cooperationKey, nodeId).isPresent();
    }

    public DataSession<?> openSession() {
        this.log.debug("Opening session with serializable transaction isolation");
        DataSession dataSession = this.sessionSupplier.openSerializableTransactionSession("nexus");
        this.log.debug("Opened session with serializable transaction isolation");
        return dataSession;
    }
}

