/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonatype.nexus.rest.ValidationErrorXO;

public class ValidationErrorsException
extends RuntimeException {
    private final List<ValidationErrorXO> errors = new ArrayList<ValidationErrorXO>();

    public ValidationErrorsException() {
    }

    public ValidationErrorsException(String message) {
        this.errors.add(new ValidationErrorXO(message));
    }

    public ValidationErrorsException(String message, Throwable e) {
        super(e);
        this.errors.add(new ValidationErrorXO(message));
    }

    public ValidationErrorsException(String id, String message) {
        this.errors.add(new ValidationErrorXO(id, message));
    }

    public ValidationErrorsException withError(String message) {
        this.errors.add(new ValidationErrorXO(message));
        return this;
    }

    public ValidationErrorsException withError(String id, String message) {
        this.errors.add(new ValidationErrorXO(id, message));
        return this;
    }

    public ValidationErrorsException withErrors(ValidationErrorXO ... validationErrors) {
        Preconditions.checkNotNull((Object)validationErrors);
        this.errors.addAll(Arrays.asList(validationErrors));
        return this;
    }

    public ValidationErrorsException withErrors(List<ValidationErrorXO> validationErrors) {
        Preconditions.checkNotNull(validationErrors);
        this.errors.addAll(validationErrors);
        return this;
    }

    public List<ValidationErrorXO> getValidationErrors() {
        return this.errors;
    }

    public boolean hasValidationErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        for (ValidationErrorXO error : this.errors) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(error.getMessage());
        }
        return sb.length() == 0 ? "(No validation errors)" : sb.toString();
    }
}

