/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.rest.Component;
import org.sonatype.nexus.rest.FaultXO;

public abstract class ExceptionMapperSupport<E extends Throwable>
implements ExceptionMapper<E>,
Component {
    public static final String X_SIESTA_FAULT_ID = "X-Siesta-FaultId";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public Response toResponse(E exception) {
        Response response;
        Preconditions.checkNotNull(exception);
        String id = ExceptionMapperSupport.generateFaultId();
        if (this.log.isTraceEnabled()) {
            this.log.trace("(ID {}) Mapping exception: " + exception, (Object)id, exception);
        } else {
            this.log.debug("(ID {}) Mapping exception: " + exception, (Object)id);
        }
        try {
            response = this.convert(exception, id);
        }
        catch (Exception e) {
            this.log.warn("(ID {}) Failed to map exception", (Object)id, (Object)e);
            response = Response.serverError().entity((Object)new FaultXO(id, e)).build();
        }
        response.getHeaders().putSingle((Object)X_SIESTA_FAULT_ID, (Object)id);
        Object entity = response.getEntity();
        this.log.warn("(ID {}) Response: [{}] {}; mapped from: {}", new Object[]{id, response.getStatus(), entity == null ? "(no entity/body)" : String.format("'%s'", entity), exception, this.log.isDebugEnabled() ? exception : null});
        return response;
    }

    private static String generateFaultId() {
        return UUID.randomUUID().toString();
    }

    protected abstract Response convert(E var1, String var2);

    protected Response unexpectedResponse(Throwable exception, String id) {
        this.log.warn("(ID {}) Unexpected exception: {}", new Object[]{id, exception.toString(), exception});
        return Response.serverError().entity((Object)String.format("ERROR: (ID %s) %s", id, exception)).type("text/plain").build();
    }
}

