/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.rapture.internal.HealthCheckCacheManager;

@Named
@Singleton
public class HealthCheckStateContributor
extends ComponentSupport
implements StateContributor {
    @VisibleForTesting
    protected static final String HC_FAILED_KEY = "health_checks_failed";
    private HealthCheckCacheManager healthCheckCacheManager;

    @Inject
    public HealthCheckStateContributor(HealthCheckCacheManager healthCheckCacheManager) {
        this.healthCheckCacheManager = (HealthCheckCacheManager)((Object)Preconditions.checkNotNull((Object)((Object)healthCheckCacheManager)));
    }

    @Override
    @Nullable
    public Map<String, Object> getState() {
        return ImmutableMap.of((Object)HC_FAILED_KEY, (Object)this.healthCheckCacheManager.getResults().values().stream().anyMatch(result -> !result.isHealthy()));
    }
}

