/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.settings;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.rapture.internal.settings.SettingsCapabilityConfiguration;

@Named(value="rapture.settings")
@Singleton
public class SettingsCapabilityDescriptor
extends CapabilityDescriptorSupport<SettingsCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "rapture.settings";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"rapture.settings");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new StringTextFormField("title", messages.titleLabel(), messages.titleHelp(), true).withInitialValue("Nexus Repository Manager"), new CheckboxFormField("debugAllowed", messages.debugAllowedLabel(), messages.debugAllowedHelp(), false).withInitialValue(Boolean.valueOf(true)), new NumberTextFormField("statusIntervalAuthenticated", messages.statusIntervalAuthenticatedLabel(), messages.statusIntervalAuthenticatedHelp(), true).withInitialValue((Number)5), new NumberTextFormField("statusIntervalAnonymous", messages.statusIntervalAnonymousLabel(), messages.statusIntervalAnonymousHelp(), true).withInitialValue((Number)60), new NumberTextFormField("sessionTimeout", messages.sessionTimeoutLabel(), messages.sessionTimeoutHelp(), true).withInitialValue((Number)30), new NumberTextFormField("requestTimeout", messages.requestTimeoutLabel(), messages.requestTimeoutHelp(), true).withInitialValue((Number)60).withMinimumValue((Number)30), new NumberTextFormField("longRequestTimeout", messages.longRequestTimeoutLabel(), messages.longRequestTimeoutHelp(), true).withInitialValue((Number)180).withMinimumValue((Number)180), new NumberTextFormField("searchRequestTimeout", messages.searchRequestTimeoutLabel(), messages.searchRequestTimeoutHelp(), false).withMinimumValue((Number)0)});

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected SettingsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new SettingsCapabilityConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("rapture.settings-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"UI")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="UI: Settings")
        public String name();

        @MessageBundle.DefaultMessage(value="Debug allowed")
        public String debugAllowedLabel();

        @MessageBundle.DefaultMessage(value="Allow developer debugging")
        public String debugAllowedHelp();

        @MessageBundle.DefaultMessage(value="Authenticated user status interval")
        public String statusIntervalAuthenticatedLabel();

        @MessageBundle.DefaultMessage(value="Interval between status requests for authenticated users (seconds)")
        public String statusIntervalAuthenticatedHelp();

        @MessageBundle.DefaultMessage(value="Anonymous user status interval")
        public String statusIntervalAnonymousLabel();

        @MessageBundle.DefaultMessage(value="Interval between status requests for anonymous user (seconds)")
        public String statusIntervalAnonymousHelp();

        @MessageBundle.DefaultMessage(value="Session timeout")
        public String sessionTimeoutLabel();

        @MessageBundle.DefaultMessage(value="Period of inactivity before session times out (minutes). A value of 0 will mean that a session never expires.")
        public String sessionTimeoutHelp();

        @MessageBundle.DefaultMessage(value="Standard request timeout")
        public String requestTimeoutLabel();

        @MessageBundle.DefaultMessage(value="Period of time to keep the connection alive for requests expected to take a normal period of time (seconds)")
        public String requestTimeoutHelp();

        @MessageBundle.DefaultMessage(value="Extended request timeout")
        public String longRequestTimeoutLabel();

        @MessageBundle.DefaultMessage(value="Period of time to keep the connection alive for requests expected to take an extended period of time (seconds)")
        public String longRequestTimeoutHelp();

        @MessageBundle.DefaultMessage(value="Search request timeout")
        public String searchRequestTimeoutLabel();

        @MessageBundle.DefaultMessage(value="Period of time to keep the connection alive for search requests (seconds); this value should be less than the request time in order for the correct error messages to be displayed. If this value is not set, the standard request timeout will be used instead.")
        public String searchRequestTimeoutHelp();

        @MessageBundle.DefaultMessage(value="Title")
        public String titleLabel();

        @MessageBundle.DefaultMessage(value="Browser page title")
        public String titleHelp();
    }
}

