/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.security;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.text.Strings2;

@Named
@Singleton
@FeatureFlag(name="nexus.session.enabled")
public class SessionAuthenticationFilter
extends AuthenticatingFilter {
    private static final Logger log = LoggerFactory.getLogger(SessionAuthenticationFilter.class);
    public static final String NAME = "nx-session-authc";
    public static final String P_USERNAME = "username";
    public static final String P_PASSWORD = "password";
    public static final String DELETE_METHOD = "DELETE";

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Subject subject = this.getSubject(request, response);
        return subject.isAuthenticated() || this.isLogoutRequest(request);
    }

    private void denied(ServletResponse response) {
        if (response instanceof HttpServletResponse) {
            WebUtils.toHttp((ServletResponse)response).setStatus(403);
        }
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        boolean authenticated = false;
        if (this.isLoginRequest(request, response)) {
            log.trace("Attempting authentication");
            authenticated = this.executeLogin(request, response);
        }
        if (!authenticated) {
            log.trace("Access denied");
            this.denied(response);
        }
        return authenticated;
    }

    protected boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && WebUtils.toHttp((ServletRequest)request).getMethod().equalsIgnoreCase("POST");
    }

    private boolean isLogoutRequest(ServletRequest request) {
        return request instanceof HttpServletRequest && WebUtils.toHttp((ServletRequest)request).getMethod().equalsIgnoreCase(DELETE_METHOD);
    }

    private String decodeBase64Param(ServletRequest request, String name) {
        String encoded = WebUtils.getCleanParam((ServletRequest)request, (String)name);
        if (encoded != null) {
            return Strings2.decodeBase64((String)encoded);
        }
        return null;
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        String username = this.decodeBase64Param(request, P_USERNAME);
        String password = this.decodeBase64Param(request, P_PASSWORD);
        return this.createToken(username, password, request, response);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        log.debug("Success: token={}, subject={}", (Object)token, (Object)subject);
        return true;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        log.debug("Failure: token={}", (Object)token, (Object)e);
        this.denied(response);
        return false;
    }
}

