/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.security;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rapture.internal.security.SessionAuthenticationFilter;
import org.sonatype.nexus.security.JwtHelper;

@Named
@Singleton
@FeatureFlag(name="nexus.jwt.enabled")
public class JwtAuthenticationFilter
extends SessionAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    public static final String NAME = "nx-jwt-authc";
    private final JwtHelper jwtHelper;

    @Inject
    public JwtAuthenticationFilter(JwtHelper jwtHelper) {
        this.jwtHelper = (JwtHelper)Preconditions.checkNotNull((Object)jwtHelper);
    }

    @Override
    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        log.debug("Success: token={}, subject={}", (Object)token, (Object)subject);
        Cookie cookie = this.jwtHelper.createJwtCookie(subject);
        ((HttpServletResponse)response).addCookie(cookie);
        return true;
    }
}

