/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rapture.internal.security.SessionAuthenticationFilter;
import org.sonatype.nexus.rapture.internal.security.SessionServlet;
import org.sonatype.nexus.security.CookieFilter;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.FilterProviderSupport;
import org.sonatype.nexus.security.SecurityFilter;

@Named
@FeatureFlag(name="nexus.session.enabled")
public class RaptureSessionModule
extends AbstractModule {
    private static final String MOUNT_POINT = "/service/rapture";
    private static final String SESSION_MP = "/service/rapture/session";

    protected void configure() {
        this.bind(FilterProviderSupport.filterKey((String)"nx-session-authc")).to(SessionAuthenticationFilter.class);
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.serve(RaptureSessionModule.SESSION_MP, new String[0]).with(SessionServlet.class);
                this.filter(RaptureSessionModule.SESSION_MP, new String[0]).through(SecurityFilter.class);
                this.filter(RaptureSessionModule.SESSION_MP, new String[0]).through(CookieFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain(RaptureSessionModule.SESSION_MP, "nx-session-authc");
            }
        });
    }
}

