/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rapture.internal.security.JwtAuthenticationFilter;
import org.sonatype.nexus.rapture.internal.security.JwtServlet;
import org.sonatype.nexus.security.CookieFilter;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.FilterProviderSupport;
import org.sonatype.nexus.security.JwtSecurityFilter;

@Named
@FeatureFlag(name="nexus.jwt.enabled")
public class RaptureJwtModule
extends AbstractModule {
    private static final String MOUNT_POINT = "/service/rapture";
    private static final String SESSION_MP = "/service/rapture/session";

    protected void configure() {
        this.bind(FilterProviderSupport.filterKey((String)"nx-jwt-authc")).to(JwtAuthenticationFilter.class);
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.serve(RaptureJwtModule.SESSION_MP, new String[0]).with(JwtServlet.class);
                this.filter(RaptureJwtModule.SESSION_MP, new String[0]).through(JwtSecurityFilter.class);
                this.filter(RaptureJwtModule.SESSION_MP, new String[0]).through(CookieFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain(RaptureJwtModule.SESSION_MP, "nx-jwt-authc");
            }
        });
    }
}

