/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.repository.conan.AssetKind;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="conan", from="1.0", to="1.1")
@Dependencies(value={@DependsOn(model="component", version="1.14", checkpoint=true), @DependsOn(model="config", version="1.8")})
public class ConanUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String P_ASSET_NAME = "name";
    private static final String P_ATTRIBUTES = "attributes";
    private static final String ASSET_CLASS_NAME = "asset";
    private static final String REPOSITORY_CLASS_NAME = "repository";
    private static final String C_BROWSE_NODE = "browse_node";
    private static final String BROWSE_NODE_CLASS = new OClassNameBuilder().type("browse_node").build();
    private static final String DELETE_BROWSE_NODE_FROM_REPOSITORIES = String.format("delete from %s where repository_name in ?", BROWSE_NODE_CLASS);
    private static final String DELETE_FROM_ASSET_WHERE_BUCKET_AND_ASSET_KIND = String.format("delete from %s where bucket = ? and attributes.conan.asset_kind = ? ", "asset");
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ConanUpgrade_1_1(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() {
        if (ConanUpgrade_1_1.hasSchemaClass(this.configDatabaseInstance, (String)REPOSITORY_CLASS_NAME) && ConanUpgrade_1_1.hasSchemaClass(this.componentDatabaseInstance, (String)ASSET_CLASS_NAME)) {
            List<String> repositories;
            List<String> hostedRepositoryNames;
            List<String> proxyRepositoryNames = this.findRepositoryNames(Collections.singletonList("conan-proxy"));
            if (!proxyRepositoryNames.isEmpty()) {
                this.updateAssetPathProxy(proxyRepositoryNames);
            }
            if (!(hostedRepositoryNames = this.findRepositoryNames(Collections.singletonList("conan-hosted"))).isEmpty()) {
                this.updateHostedAssetPath(hostedRepositoryNames);
                this.deleteDownloadUrls(hostedRepositoryNames);
            }
            if (!(repositories = Stream.concat(proxyRepositoryNames.stream(), hostedRepositoryNames.stream()).collect(Collectors.toList())).isEmpty()) {
                this.removeAttributesFromConanManifest(repositories);
                this.deleteConanBrowseNodes(repositories);
            }
        }
    }

    private List<String> findRepositoryNames(List<String> recipes) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx oDatabaseDocumentTx = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            List documents = oDatabaseDocumentTx.query((OQuery)new OSQLSynchQuery("select from repository where recipe_name in ?"), new Object[]{recipes});
            return documents.stream().map(entries -> (String)entries.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void removeAttributesFromConanManifest(List<String> repositoryNames) {
        DatabaseUpgradeSupport.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET_CLASS_NAME, (db, type) -> {
            String selectAssetQuery = String.format("select from asset where bucket = ? and attributes.conan.asset_kind = '%s'", AssetKind.CONAN_MANIFEST.name());
            this.findAssets((ODatabaseDocumentTx)db, repositoryNames, selectAssetQuery).forEach(oDocument -> {
                Map attributes = (Map)oDocument.field(P_ATTRIBUTES);
                attributes.put("conan", Collections.singletonMap("asset_kind", AssetKind.CONAN_MANIFEST.name()));
                oDocument.field(P_ATTRIBUTES, (Object)attributes);
                oDocument.save();
            });
        });
    }

    private void updateAssetPathProxy(List<String> proxyRepositoryNames) {
        DatabaseUpgradeSupport.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET_CLASS_NAME, (db, type) -> this.findAssets((ODatabaseDocumentTx)db, proxyRepositoryNames, "select from asset where bucket = ?").forEach(oDocument -> {
            String name = (String)oDocument.field(P_ASSET_NAME);
            String nextName = null;
            String strategy2 = "v1/conans/";
            String conans = "conans/";
            if (name.startsWith(strategy2)) {
                nextName = String.valueOf(conans) + name.substring(strategy2.length());
            } else if (!name.startsWith(conans)) {
                String preName = name;
                String[] values = name.split("/");
                Map attributes = (Map)oDocument.field(P_ATTRIBUTES);
                Map conan = (Map)attributes.get("conan");
                String assetKindName = (String)conan.get("asset_kind");
                AssetKind assetKind = AssetKind.valueOf(assetKindName);
                if (assetKind == AssetKind.DOWNLOAD_URL) {
                    String expectPackage = values[4];
                    if (expectPackage.equals("packages")) {
                        String group = values[0];
                        String project = values[1];
                        String version = values[2];
                        String channel = values[3];
                        String sha = values[5];
                        String fileName = values[6];
                        preName = String.valueOf(project) + "/" + version + "/" + group + "/" + channel + "/packages/" + sha + "/" + fileName;
                    } else {
                        String group = values[0];
                        String project = values[1];
                        String version = values[2];
                        String channel = values[3];
                        String fileName = values[4];
                        preName = String.valueOf(project) + "/" + version + "/" + group + "/" + channel + "/" + fileName;
                    }
                }
                nextName = String.valueOf(conans) + preName;
            }
            if (nextName != null) {
                oDocument.field(P_ASSET_NAME, nextName);
                oDocument.save();
            }
        }));
    }

    private void updateHostedAssetPath(List<String> repositoryNames) {
        DatabaseUpgradeSupport.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET_CLASS_NAME, (db, type) -> this.findAssets((ODatabaseDocumentTx)db, repositoryNames, "select from asset where bucket = ?").forEach(oDocument -> {
            Map attributes = (Map)oDocument.field(P_ATTRIBUTES);
            Map conan = (Map)attributes.get("conan");
            String asset_kind = (String)conan.get("asset_kind");
            AssetKind assetKind = AssetKind.valueOf(asset_kind);
            if (AssetKind.DOWNLOAD_URL == assetKind) {
                return;
            }
            String name = (String)oDocument.field(P_ASSET_NAME);
            String nextName = null;
            String strategy0 = "/v1/conans/v1/conans/v1/conans/";
            String strategy1 = "/v1/conans/v1/conans/";
            String strategy3 = "/v1/conans/";
            String conans = "conans/";
            if (name.startsWith(strategy0)) {
                nextName = String.valueOf(conans) + name.substring(strategy0.length());
            } else if (name.startsWith(strategy1)) {
                nextName = String.valueOf(conans) + name.substring(strategy1.length());
            } else if (name.startsWith(strategy3)) {
                nextName = String.valueOf(conans) + name.substring(strategy3.length());
            }
            if (nextName != null) {
                oDocument.field(P_ASSET_NAME, (Object)nextName);
                oDocument.save();
            }
        }));
    }

    private Stream<ODocument> findAssets(ODatabaseDocumentTx db, List<String> repositoryNames, String SQL) {
        return repositoryNames.stream().flatMap(repositoryName -> {
            OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(new OIndexNameBuilder().type("bucket").property(P_REPOSITORY_NAME).build());
            OIdentifiable bucket = (OIdentifiable)bucketIdx.get(repositoryName);
            if (bucket == null) {
                this.log.debug("Unable to find bucket for {}", repositoryName);
                return Stream.empty();
            }
            List assets = db.query((OQuery)new OSQLSynchQuery(SQL), new Object[]{bucket.getIdentity()});
            return assets.stream();
        });
    }

    private void deleteConanBrowseNodes(List<String> repositoryNames) {
        this.log.debug("Deleting browse_node data from conan repositories to be rebuilt ({}).", repositoryNames);
        DatabaseUpgradeSupport.withDatabaseAndClass(this.componentDatabaseInstance, (String)C_BROWSE_NODE, (db, type) -> {
            OSchemaProxy schema = db.getMetadata().getSchema();
            if (schema.existsClass(C_BROWSE_NODE)) {
                db.command((OCommandRequest)new OCommandSQL(DELETE_BROWSE_NODE_FROM_REPOSITORIES)).execute(new Object[]{repositoryNames});
            }
        });
    }

    private void deleteDownloadUrls(List<String> repositoryNames) {
        this.log.debug("Deleting DOWNLOAD_URLS assets from conan repositories ({}).", repositoryNames);
        DatabaseUpgradeSupport.withDatabaseAndClass(this.componentDatabaseInstance, (String)ASSET_CLASS_NAME, (db, type) -> {
            OSchemaProxy schema = db.getMetadata().getSchema();
            if (schema.existsClass(ASSET_CLASS_NAME)) {
                repositoryNames.forEach(repositoryName -> {
                    OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(new OIndexNameBuilder().type("bucket").property(P_REPOSITORY_NAME).build());
                    OIdentifiable bucket = (OIdentifiable)bucketIdx.get(repositoryName);
                    db.command((OCommandRequest)new OCommandSQL(DELETE_FROM_ASSET_WHERE_BUCKET_AND_ASSET_KIND)).execute(new Object[]{bucket, AssetKind.DOWNLOAD_URL.name()});
                });
            }
        });
    }
}

