/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.security.token;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.internal.security.token.ConanTokenFacet;
import com.sonatype.repository.conan.internal.security.token.ConanTokenManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
public class ConanTokenFacetImpl
extends FacetSupport
implements ConanTokenFacet {
    private final ConanTokenManager conanTokenManager;

    @Inject
    public ConanTokenFacetImpl(ConanTokenManager conanTokenManager) {
        this.conanTokenManager = (ConanTokenManager)((Object)Preconditions.checkNotNull((Object)((Object)conanTokenManager)));
    }

    @Override
    public Response login(Context context) {
        String token = this.conanTokenManager.login();
        if (token != null) {
            return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(token, "text/plain")).build();
        }
        return ConanTokenFacetImpl.badCredentials("Bad username or password");
    }

    @Override
    public Response user(Context context) {
        String user = this.conanTokenManager.user();
        if (user != null) {
            return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(user, "text/plain")).build();
        }
        return ConanTokenFacetImpl.badCredentials("Unknown user");
    }

    @Override
    public Response logout(Context context) {
        return null;
    }

    static Response badCredentials(String message) {
        return new Response.Builder().status(Status.failure((int)401)).payload((Payload)new StringPayload(message, "text/plain")).build();
    }
}

