/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.proxy.v1;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.proxy.ProxyHandler;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanProxyHandlers {
    public static final int DEFAULT_SEARCH_TIMEOUT = 120000;
    @Inject
    public ProxyHandler proxyHandler;
    public final Handler searchQueryHandler = context -> {
        Parameters parameters = context.getRequest().getParameters();
        List listParameters = StreamSupport.stream(parameters.spliterator(), false).map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        String path = context.getRequest().getPath().substring(1);
        URI remoteUrl = ((ProxyFacet)context.getRepository().facet(ProxyFacet.class)).getRemoteUrl();
        URI nextUri = remoteUrl.resolve(path);
        URI requestUri = new URIBuilder(nextUri).addParameters(listParameters).build();
        HttpClient httpClient = ((HttpClientFacet)context.getRepository().facet(HttpClientFacet.class)).getHttpClient();
        HttpGet httpGet = new HttpGet(requestUri);
        int timeout = SystemPropertiesHelper.getInteger((String)"nexus.conan.proxy.search.timeout", (int)120000);
        RequestConfig params = RequestConfig.custom().setSocketTimeout(timeout).build();
        httpGet.setConfig(params);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        HttpEntity entity = response.getEntity();
        String JSON = EntityUtils.toString((HttpEntity)entity);
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(JSON, "application/json")).build();
    };
}

