/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.orient.ui;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.internal.common.ConanBrowseNodeGeneratorHelper;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="conan")
public class OrientConanBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        ArrayList<String> componentList = new ArrayList<String>();
        componentList.add(component.group());
        componentList.add(component.name());
        componentList.add(component.version());
        return BrowsePaths.fromPaths(componentList, (boolean)true);
    }

    public List<BrowsePaths> computeAssetPaths(Asset asset, Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<BrowsePaths> strings = this.computeComponentPaths(asset, component);
            strings.addAll(BrowsePaths.fromPaths(ConanBrowseNodeGeneratorHelper.assetSegment(asset.name()), (boolean)false));
            return strings;
        }
        return super.computeAssetPaths(asset, null);
    }
}

