/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.orient.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.orient.proxy.v1.OrientConanProxyHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Singleton
@Named
public class ConanUrlIndexer
extends ComponentSupport {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public String updateAbsoluteUrls(Context context, Content content, Repository repository) throws IOException {
        Map<String, URL> downloadUrlContents = this.readIndex(content.openInputStream());
        HashMap<String, String> remappedContents = new HashMap<String, String>();
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coords = OrientConanProxyHelper.convertFromState(state);
        for (Map.Entry<String, URL> entry : downloadUrlContents.entrySet()) {
            String fileName = entry.getKey();
            AssetKind assetKind = OrientConanProxyHelper.ASSET_KIND_FILENAMES.get(fileName);
            remappedContents.put(entry.getKey(), String.valueOf(repository.getUrl()) + "/" + OrientConanProxyHelper.getProxyAssetPath(coords, assetKind));
        }
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(remappedContents);
    }

    private Map<String, URL> readIndex(InputStream stream) {
        ObjectMapper objectMapper = new ObjectMapper();
        TypeReference<HashMap<String, URL>> typeRef = new TypeReference<HashMap<String, URL>>(){};
        try {
            return (Map)objectMapper.readValue(stream, (TypeReference)typeRef);
        }
        catch (IOException e) {
            this.log.warn("Unable to read index for asset", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public String findUrl(InputStream inputStream, String find) {
        Map<String, URL> downloadUrlContents = this.readIndex(inputStream);
        if (downloadUrlContents.containsKey(find)) {
            return downloadUrlContents.get(find).toString();
        }
        return null;
    }
}

