/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.orient.hosted.v1;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.ConanFacetUtils;
import com.sonatype.repository.conan.internal.hosted.ConanHostedFacet;
import com.sonatype.repository.conan.internal.hosted.ConanHostedHelper;
import com.sonatype.repository.conan.internal.orient.hosted.ConanHostedMetadataFacetSupport;
import com.sonatype.repository.conan.internal.orient.proxy.v1.OrientConanProxyHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientConanHostedFacet
extends ConanHostedMetadataFacetSupport
implements ConanHostedFacet {
    @Override
    public Response upload(ConanCoords coord, Payload payload, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)coord);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)((Object)assetKind));
        this.doPutArchive(coord, payload, assetKind);
        return new Response.Builder().status(Status.success((int)200)).build();
    }

    private void doPutArchive(ConanCoords coord, Payload payload, AssetKind assetKind) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, ConanFacetUtils.HASH_ALGORITHMS);){
            this.doPutArchive(coord, ConanHostedHelper.getHostedAssetPath(coord, assetKind), tempBlob, assetKind);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected void doPutArchive(ConanCoords coord, String path, TempBlob tempBlob, AssetKind assetKind) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)tempBlob);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("group", coord.getGroup());
        attributes.put("project", coord.getProject());
        attributes.put("version", coord.getVersion());
        attributes.put("state", coord.getChannel());
        Component component = com.sonatype.repository.conan.internal.orient.utils.ConanFacetUtils.findComponent(tx, this.getRepository(), coord);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).group(coord.getGroup()).name(coord.getProject())).version(OrientConanProxyHelper.getComponentVersion(coord));
        }
        tx.saveComponent(component);
        Asset asset = com.sonatype.repository.conan.internal.orient.utils.ConanFacetUtils.findAsset(tx, bucket, path);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)assetKind);
        }
        this.saveAsset(tx, asset, (InputStreamSupplier)tempBlob);
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public String getDownloadUrlAsJson(ConanCoords coords) throws JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)coords.getSha())) {
            return this.generateDownloadUrlsAsJson(coords);
        }
        return this.generateDownloadPackagesUrlsAsJson(coords);
    }

    @Override
    public String getUploadUrlAsJson(ConanCoords coords, Set<String> assetsToUpload) throws JsonProcessingException {
        return ConanHostedHelper.getUploadUrlAsJson(coords, assetsToUpload, this.getRepository());
    }

    @Override
    public String getDigestAsJson(ConanCoords coords) throws JsonProcessingException {
        String repositoryUrl = this.getRepository().getUrl();
        return this.generateDigestAsJson(coords, repositoryUrl);
    }

    private Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier) throws IOException {
        return this.saveAsset(tx, asset, contentSupplier, null, null);
    }

    private Content saveAsset(StorageTx tx, Asset asset, InputStreamSupplier contentSupplier, String contentType, AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), contentSupplier, OrientConanProxyHelper.HASH_ALGORITHMS, null, contentType, false);
        asset.markAsDownloaded();
        tx.saveAsset(asset);
        return OrientConanProxyHelper.toContent(asset, assetBlob.getBlob());
    }

    @Override
    public Response get(Context context) {
        this.log.debug("Request {}", (Object)context.getRequest().getPath());
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        String assetPath = ConanHostedHelper.getHostedAssetPath(coord, assetKind);
        Content content = this.doGet(assetPath);
        if (content == null) {
            return HttpResponses.notFound();
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StreamPayload(() -> ((Content)content).openInputStream(), content.getSize(), content.getContentType())).build();
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content doGet(String path) {
        Preconditions.checkNotNull((Object)path);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = com.sonatype.repository.conan.internal.orient.utils.ConanFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            return null;
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return OrientConanProxyHelper.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }
}

