/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.hosted.v1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.datastore.search.ConanSearchFacet;
import com.sonatype.repository.conan.internal.datastore.search.InvalidSearchQueryException;
import com.sonatype.repository.conan.internal.hosted.ConanHostedFacet;
import com.sonatype.repository.conan.internal.hosted.ConanHostedHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class ConanHostedHandlers
extends ComponentSupport {
    private static final String CLIENT_CHECKSUM = "X-Checksum-Sha1";
    private static ObjectReader objectReader = new ObjectMapper().readerFor((TypeReference)new TypeReference<HashMap<String, String>>(){});
    public static final Handler uploadUrl = context -> {
        Map uploadRequestData;
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        Payload payload = context.getRequest().getPayload();
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream inputStream = payload.openInputStream();){
            uploadRequestData = (Map)objectReader.readValue(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (uploadRequestData != null && !uploadRequestData.isEmpty()) {
            String downloadUrlAsJson = ((ConanHostedFacet)context.getRepository().facet(ConanHostedFacet.class)).getUploadUrlAsJson(coord, uploadRequestData.keySet());
            return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(downloadUrlAsJson, "application/json")).build();
        }
        return new Response.Builder().status(Status.failure((int)400)).build();
    };
    public static final Handler uploadContentHandler = context -> {
        Headers headers = context.getRequest().getHeaders();
        String method = context.getRequest().getAction();
        if (headers.contains(CLIENT_CHECKSUM) && !method.equals("PUT")) {
            return new Response.Builder().status(Status.failure((int)404)).build();
        }
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        AssetKind assetKind = (AssetKind)((Object)((Object)context.getAttributes().require(AssetKind.class)));
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        return ((ConanHostedFacet)context.getRepository().facet(ConanHostedFacet.class)).upload(coord, context.getRequest().getPayload(), assetKind);
    };
    public static final Handler getDownloadUrl = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        String json = ((ConanHostedFacet)context.getRepository().facet(ConanHostedFacet.class)).getDownloadUrlAsJson(coord);
        if (json != null) {
            return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(json, "application/json")).build();
        }
        return new Response.Builder().status(Status.failure((int)404)).build();
    };
    public static final Handler getDigest = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        String json = ((ConanHostedFacet)context.getRepository().facet(ConanHostedFacet.class)).getDigestAsJson(coord);
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(json, "application/json")).build();
    };
    public static final Handler getAssets = context -> ((ConanHostedFacet)context.getRepository().facet(ConanHostedFacet.class)).get(context);
    public static final Handler getPackageSnapshot = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        String json = ((ConanHostedFacet)context.getRepository().facet(ConanHostedFacet.class)).generatePackageSnapshotAsJson(coord);
        if (StringUtils.isEmpty((CharSequence)json)) {
            return new Response.Builder().status(Status.failure((int)404)).build();
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(json, "application/json")).build();
    };
    public static final Handler SEARCH_QUERY_HANDLER = context -> {
        List componentNames;
        Parameters parameters = context.getRequest().getParameters();
        String query = parameters.get("q");
        if (StringUtils.isBlank((CharSequence)query)) {
            return new Response.Builder().status(Status.failure((int)400)).build();
        }
        try {
            componentNames = ((ConanSearchFacet)context.getRepository().facet(ConanSearchFacet.class)).componentSearch(query).map(ConanHostedHandlers::toFullReference).collect(Collectors.toList());
        }
        catch (InvalidSearchQueryException invalidSearchQueryException) {
            return new Response.Builder().status(Status.failure((int)400, (String)"Invalid search query")).build();
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(ConanHostedHelper.MAPPER.writeValueAsString((Object)ImmutableMap.of((Object)"results", componentNames)), "application/json")).build();
    };
    public static final Handler LIST_BINARIES = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        ConanCoords coord = ConanHostedHelper.convertFromState(state);
        List assets = ((ConanSearchFacet)context.getRepository().facet(ConanSearchFacet.class)).listExistingBinaries(coord).collect(Collectors.toList());
        ObjectNode rootNode = ConanHostedHelper.MAPPER.createObjectNode();
        for (FluentAsset fluentAsset : assets) {
            Optional<String> id = ConanHostedHandlers.extractId(fluentAsset.path());
            if (!id.isPresent()) continue;
            ObjectNode packageNode = rootNode.putObject(id.get());
            String conanInfo = ConanHostedHandlers.downloadToString(fluentAsset);
            ConanHostedHandlers.toJson(conanInfo, packageNode);
        }
        return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(ConanHostedHelper.MAPPER.writeValueAsString((Object)rootNode), "application/json")).build();
    };

    static String toFullReference(Component component) {
        return String.format("%s/%s@%s/%s", component.name(), ConanHostedHandlers.getAttribute(component, "baseVersion"), Optional.ofNullable(component.namespace()).orElse("_"), ConanHostedHandlers.getAttribute(component, "channel"));
    }

    static String getAttribute(Component component, String key) {
        return Optional.ofNullable(component.attributes("conan")).map(conanAttributes -> (String)conanAttributes.get(key, String.class)).orElse("_");
    }

    private static void toJson(String conanInfo, ObjectNode packageNode) {
        Pattern tagPattern = Pattern.compile("\\[[^\\]]+?\\][^\\[]*", 32);
        Matcher tagMatcher = tagPattern.matcher(conanInfo);
        while (tagMatcher.find()) {
            String[] section = tagMatcher.group().split("[\n\r]+");
            if (section.length < 2) continue;
            String header = section[0].replaceAll("[\\[\\]]", "");
            String[] fields = Arrays.copyOfRange(section, 1, section.length);
            switch (header) {
                case "options": 
                case "settings": {
                    ConanHostedHandlers.putObject(packageNode, header, fields);
                    break;
                }
                case "requires": {
                    ConanHostedHandlers.putArray(packageNode, header, fields);
                    break;
                }
                case "recipe_hash": {
                    ConanHostedHandlers.putField(packageNode, header, fields);
                }
            }
        }
    }

    private static void putObject(ObjectNode packageNode, String fieldName, String[] values) {
        ObjectNode sectionNode = packageNode.putObject(fieldName);
        Arrays.stream(values).forEach(field -> {
            String[] fieldPair = field.split("=", 2);
            if (fieldPair.length == 2) {
                sectionNode.put(StringUtils.trim((String)fieldPair[0]), StringUtils.trim((String)fieldPair[1]));
            }
        });
    }

    private static void putArray(ObjectNode packageNode, String fieldName, String[] values) {
        ArrayNode sectionNode = packageNode.putArray(fieldName);
        Arrays.stream(values).forEach(arg_0 -> ((ArrayNode)sectionNode).add(arg_0));
    }

    private static void putField(ObjectNode packageNode, String fieldName, String[] values) {
        packageNode.put(fieldName, values[0]);
    }

    private static String downloadToString(FluentAsset fluentAsset) throws IOException {
        return IOUtils.toString((Reader)new InputStreamReader(fluentAsset.markAsDownloaded().download().openInputStream()));
    }

    private static Optional<String> extractId(String path) {
        return Optional.ofNullable(path).map(p -> p.split("/")).filter(parts -> ((String[])parts).length >= 2).map(parts -> parts[((String[])parts).length - 2]);
    }
}

