/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.hosted;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanCoords;
import java.util.HashMap;
import java.util.Set;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class ConanHostedHelper {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String CONAN_HOSTED_PREFIX = "conans/";

    public static String getHostedAssetPath(ConanCoords coord, AssetKind assetKind) {
        String path = String.format("%s/%s/%s/%s%s", coord.getGroup(), coord.getProject(), coord.getVersion(), coord.getChannel(), coord.getSha() == null ? "" : "/packages/" + coord.getSha());
        return String.format("%s%s/%s", CONAN_HOSTED_PREFIX, path, assetKind.getFilename());
    }

    public static ConanCoords convertFromState(TokenMatcher.State state) {
        return new ConanCoords((String)state.getTokens().get("path"), (String)state.getTokens().get("group"), (String)state.getTokens().get("project"), (String)state.getTokens().get("version"), (String)state.getTokens().get("state"), state.getTokens().getOrDefault("sha", null));
    }

    public static String getUploadUrlAsJson(ConanCoords coords, Set<String> assetsToUpload, Repository repository) throws JsonProcessingException {
        String repositoryUrl = repository.getUrl();
        HashMap<String, String> downloadUrls = new HashMap<String, String>();
        for (String fileName : assetsToUpload) {
            AssetKind assetKind = AssetKind.valueFromFileName(fileName);
            if (assetKind == null) {
                throw new IllegalArgumentException("Unknown asset kind for uploading file: " + fileName);
            }
            downloadUrls.put(fileName, String.valueOf(repositoryUrl) + "/" + ConanHostedHelper.getHostedAssetPath(coords, assetKind));
        }
        return MAPPER.writeValueAsString(downloadUrls);
    }
}

