/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.search;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.ConanContentFacet;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.ConanReference;
import com.sonatype.repository.conan.internal.datastore.search.ConanSearchFacet;
import com.sonatype.repository.conan.internal.datastore.search.InvalidSearchQueryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.query.SearchFilter;

@Named
public class ConanSearchFacetImpl
extends FacetSupport
implements ConanSearchFacet {
    private final SearchService searchService;
    private static final Pattern patternOrReferencePattern = Pattern.compile("(?<name>[^@/]+)/?(?<version>[^@/]+)?@?(?<user>[^@/]+)?/?(?<channel>[^@/]+)?");

    @Inject
    public ConanSearchFacetImpl(SearchService searchService) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    private static ConanReference buildReference(String query) {
        Matcher queryMatcher = patternOrReferencePattern.matcher(query);
        if (queryMatcher.matches()) {
            return ConanReference.builder().name(queryMatcher.group("name")).version(queryMatcher.group("version")).user(queryMatcher.group("user")).channel(queryMatcher.group("channel")).build();
        }
        throw new InvalidSearchQueryException("Invalid query string: " + query);
    }

    @Override
    public Stream<FluentComponent> componentSearch(String query) {
        ConanReference reference = ConanSearchFacetImpl.buildReference(query);
        SearchRequest request = SearchRequest.builder().searchFilters(this.getFilters(reference)).build();
        return ConanSearchFacetImpl.toStream(this.searchService.browse(request)).map(this::getComponent).filter(Optional::isPresent).map(Optional::get);
    }

    private Collection<SearchFilter> getFilters(ConanReference reference) {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        this.addNameFilter(filters, reference.getName());
        this.addUserFilter(filters, reference.getUser());
        this.addVersionFilter(filters, reference.getBaseVersion(), reference.getChannel());
        return filters;
    }

    private void addNameFilter(Collection<SearchFilter> filters, String name) {
        filters.add(new SearchFilter("name.raw", name));
    }

    private void addUserFilter(Collection<SearchFilter> filters, Optional<String> user) {
        user.ifPresent(group -> {
            boolean bl = filters.add(new SearchFilter("group", group));
        });
    }

    private void addVersionFilter(Collection<SearchFilter> filters, Optional<String> baseVersion, Optional<String> channel) {
        if (baseVersion.isPresent() || channel.isPresent()) {
            filters.add(new SearchFilter("version", String.format("%s-%s", baseVersion.orElse("*"), channel.orElse("*"))));
        }
    }

    private static <T> Stream<T> toStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private Optional<FluentComponent> getComponent(ComponentSearchResult searchResult) {
        return ((ContentFacet)this.facet(ContentFacet.class)).components().find((EntityId)new DetachedEntityId(searchResult.getId()));
    }

    @Override
    public Stream<FluentAsset> listExistingBinaries(ConanCoords coord) {
        return ((ConanContentFacet)this.facet(ConanContentFacet.class)).listExistingBinaries(coord);
    }
}

