/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore.hosted;

import com.sonatype.repository.conan.ConanContentFacet;
import com.sonatype.repository.conan.internal.datastore.hosted.ConanHostedApiV1;
import com.sonatype.repository.conan.internal.datastore.search.ConanSearchFacet;
import com.sonatype.repository.conan.internal.hosted.ConanHostedFacet;
import com.sonatype.repository.conan.internal.security.ConanSecurityFacet;
import com.sonatype.repository.conan.internal.security.token.ConanTokenFacet;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.RecipeSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.maintenance.SingleAssetMaintenanceFacet;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.http.HttpHandlers;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.recipe.RouterBuilder;
import org.sonatype.nexus.repository.view.ConfigurableViewFacet;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named(value="conan-hosted")
@Singleton
public class ConanHostedRecipe
extends RecipeSupport {
    public static final String NAME = "conan-hosted";
    @Inject
    Provider<ConanSecurityFacet> securityFacet;
    @Inject
    Provider<ConfigurableViewFacet> viewFacet;
    @Inject
    Provider<ConanContentFacet> contentFacet;
    @Inject
    Provider<SearchFacet> searchFacet;
    @Inject
    Provider<SingleAssetMaintenanceFacet> componentMaintenanceFacet;
    @Inject
    Provider<HttpClientFacet> httpClientFacet;
    @Inject
    Provider<ConanHostedFacet> hostedFacet;
    @Inject
    Provider<ConanSearchFacet> conanSearchFacet;
    @Inject
    Provider<ConanTokenFacet> tokenFacet;
    @Inject
    Provider<BrowseFacet> browseFacet;
    private ConanHostedApiV1 apiV1;

    @Inject
    protected ConanHostedRecipe(@Named(value="hosted") Type type, @Named(value="conan") Format format, ConanHostedApiV1 apiV1) {
        super(type, format);
        this.apiV1 = apiV1;
    }

    public void apply(@Nonnull Repository repository) throws Exception {
        repository.attach((Facet)this.securityFacet.get());
        repository.attach((Facet)this.configure((ConfigurableViewFacet)this.viewFacet.get()));
        repository.attach((Facet)this.httpClientFacet.get());
        repository.attach((Facet)this.componentMaintenanceFacet.get());
        repository.attach((Facet)this.tokenFacet.get());
        repository.attach((Facet)this.hostedFacet.get());
        repository.attach((Facet)this.contentFacet.get());
        repository.attach((Facet)this.browseFacet.get());
        repository.attach((Facet)this.searchFacet.get());
        repository.attach((Facet)this.conanSearchFacet.get());
    }

    public ViewFacet configure(ConfigurableViewFacet facet) {
        Router.Builder builder = new Router.Builder();
        this.addBrowseUnsupportedRoute((RouterBuilder)builder);
        this.apiV1.create(builder);
        builder.defaultHandlers(new Handler[]{HttpHandlers.notFound()});
        facet.configure(builder.create());
        return facet;
    }
}

