/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore;

import com.sonatype.repository.conan.internal.security.token.ConanTokenFacet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class UserController
extends ComponentSupport {
    private static final String CHECK_CREDENTIALS_URL = "/%s/users/check_credentials";
    private static final String AUTHENTICATE_URL = "/%s/users/authenticate";
    @Inject
    private TimingHandler timingHandler;
    @Inject
    private SecurityHandler securityHandler;
    @Inject
    private ExceptionHandler exceptionHandler;
    @Inject
    private HandlerContributor handlerContributor;
    @Inject
    private ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    private PartialFetchHandler partialFetchHandler;
    @Inject
    private ContentHeadersHandler contentHeadersHandler;
    final Handler checkCredentials = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        Repository repository = context.getRepository();
        this.log.debug("[checkCredentials] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
        return ((ConanTokenFacet)repository.facet(ConanTokenFacet.class)).user(context);
    };
    final Handler authenticate = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        Repository repository = context.getRepository();
        this.log.debug("[authenticate] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
        return ((ConanTokenFacet)repository.facet(ConanTokenFacet.class)).login(context);
    };

    private static Route.Builder checkCredentials(String version) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher(String.format(CHECK_CREDENTIALS_URL, version))}));
    }

    private static Route.Builder authenticate(String version) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher(String.format(AUTHENTICATE_URL, version))}));
    }

    public void attach(Router.Builder builder, String version) {
        builder.route(UserController.checkCredentials(version).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler(this.checkCredentials).create());
        builder.route(UserController.authenticate(version).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler(this.authenticate).create());
    }
}

