/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore;

import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.internal.common.v1.ConanRoutes;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.PartialFetchHandler;
import org.sonatype.nexus.repository.routing.RoutingRuleHandler;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.handlers.ConditionalRequestHandler;
import org.sonatype.nexus.repository.view.handlers.ContentHeadersHandler;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.FormatHighAvailabilitySupportHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;

@Named
@Singleton
public class ConanControllerV1
extends ComponentSupport {
    @Inject
    protected TimingHandler timingHandler;
    @Inject
    protected SecurityHandler securityHandler;
    @Inject
    protected ExceptionHandler exceptionHandler;
    @Inject
    protected HandlerContributor handlerContributor;
    @Inject
    protected ConditionalRequestHandler conditionalRequestHandler;
    @Inject
    protected FormatHighAvailabilitySupportHandler highAvailabilitySupportHandler;
    @Inject
    protected PartialFetchHandler partialFetchHandler;
    @Inject
    protected ContentHeadersHandler contentHeadersHandler;
    @Inject
    protected LastDownloadedHandler lastDownloadedHandler;
    @Inject
    protected RoutingRuleHandler routingRuleHandler;

    private Handler assetKindHandler(final AssetKind assetKind) {
        return new Handler(){

            @Nonnull
            public Response handle(@Nonnull Context context) throws Exception {
                context.getAttributes().set(AssetKind.class, (Object)assetKind);
                return context.proceed();
            }
        };
    }

    protected void createRoute(Router.Builder builder, Route.Builder matcher, AssetKind assetKind, Handler handler) {
        builder.route(matcher.handler((Handler)this.timingHandler).handler(this.assetKindHandler(assetKind)).handler((Handler)this.securityHandler).handler((Handler)this.highAvailabilitySupportHandler).handler((org.sonatype.nexus.repository.recipe.Handler)this.routingRuleHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler((Handler)this.conditionalRequestHandler).handler((Handler)this.partialFetchHandler).handler((Handler)this.contentHeadersHandler).handler((Handler)this.lastDownloadedHandler).handler(handler).create());
    }

    protected void createGetRoutes(Router.Builder builder, Handler urlHandler, Handler fetchHandler, Handler packageHandler) {
        this.createRoute(builder, ConanRoutes.downloadUrls(), AssetKind.DOWNLOAD_URL, urlHandler);
        this.createRoute(builder, ConanRoutes.conanManifest(), AssetKind.CONAN_MANIFEST, fetchHandler);
        this.createRoute(builder, ConanRoutes.conanFile(), AssetKind.CONAN_FILE, fetchHandler);
        this.createRoute(builder, ConanRoutes.conanInfo(), AssetKind.CONAN_INFO, fetchHandler);
        this.createRoute(builder, ConanRoutes.conanPackage(), AssetKind.CONAN_PACKAGE, fetchHandler);
        this.createRoute(builder, ConanRoutes.conanSource(), AssetKind.CONAN_SOURCES, fetchHandler);
        this.createRoute(builder, ConanRoutes.conanExport(), AssetKind.CONAN_EXPORT, fetchHandler);
        this.createRoute(builder, ConanRoutes.packageSnapshot(), AssetKind.CONAN_PACKAGE_SNAPSHOT, packageHandler);
    }
}

