/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.datastore;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanContentFacet;
import com.sonatype.repository.conan.ConanCoords;
import com.sonatype.repository.conan.internal.datastore.ConanHashVerifier;
import com.sonatype.repository.conan.internal.datastore.proxy.ConanProxyHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.RepositoryContent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named(value="conan")
public class ConanContentFacetImpl
extends ContentFacetSupport
implements ConanContentFacet {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = ImmutableList.of((Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA512, (Object)HashAlgorithm.MD5);
    private final ConanHashVerifier hashVerifier;

    @Inject
    protected ConanContentFacetImpl(@Named(value="conan") FormatStoreManager formatStoreManager, ConanHashVerifier hashVerifier) {
        super(formatStoreManager);
        this.hashVerifier = hashVerifier;
    }

    @Override
    public Optional<FluentAsset> getAsset(ConanCoords coords, AssetKind assetKind) {
        return ((ContentFacet)this.facet(ContentFacet.class)).assets().path(ConanProxyHelper.getProxyAssetPath(coords, assetKind)).find();
    }

    @Override
    public FluentAsset putPackage(Payload payload, ConanCoords coords, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            return this.assets().path(ConanProxyHelper.getProxyAssetPath(coords, assetKind)).component((Component)this.getOrCreateComponent(coords)).kind(assetKind.name()).blob(tempBlob).save().markAsCached(payload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Optional<FluentAsset> putMetadata(Payload payload, ConanCoords coords, AssetKind assetKind) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = this.blobs().ingest(payload, HASH_ALGORITHMS);){
            String assetPath = ConanProxyHelper.getProxyAssetPath(coords, assetKind);
            HashCode hashFromManifest = this.hashVerifier.lookupHashFromAsset(this.getRepository(), assetPath);
            HashCode newAssetHash = (HashCode)tempBlob.getHashes().get(HashAlgorithm.MD5);
            if (!this.hashVerifier.verify(hashFromManifest, newAssetHash)) {
                return Optional.empty();
            }
            return Optional.of(this.assets().path(assetPath).component((Component)this.getOrCreateComponent(coords)).kind(assetKind.name()).blob(tempBlob).save().markAsCached(payload));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Stream<FluentAsset> listExistingBinaries(ConanCoords conanCoords) {
        return this.getComponent(conanCoords).map(this::getPackageManifests).orElse(Stream.empty());
    }

    private Stream<FluentAsset> getPackageManifests(FluentComponent component) {
        return component.assets().stream().filter(ConanContentFacetImpl::isConanInfoAsset);
    }

    private static boolean isConanInfoAsset(FluentAsset fluentAsset) {
        return fluentAsset.path().contains("packages") && fluentAsset.path().endsWith("/" + AssetKind.CONAN_INFO.getFilename());
    }

    private Optional<FluentComponent> getComponent(ConanCoords coords) {
        return this.populateBuilder(coords).find();
    }

    private FluentComponentBuilder populateBuilder(ConanCoords coords) {
        return ((ContentFacet)this.facet(ContentFacet.class)).components().name(coords.getProject()).namespace(coords.getGroup()).version(ConanProxyHelper.getComponentVersion(coords));
    }

    private FluentComponent getOrCreateComponent(ConanCoords coords) {
        FluentComponent component = this.populateBuilder(coords).getOrCreate();
        if (this.isNewRepositoryContent((RepositoryContent)component)) {
            this.setConanFormatAttributes(component, coords);
        }
        return component;
    }

    private void setConanFormatAttributes(FluentComponent component, ConanCoords coordinates) {
        HashMap<String, String> conanAttributes = new HashMap<String, String>();
        conanAttributes.put("baseVersion", coordinates.getVersion());
        conanAttributes.put("channel", coordinates.getChannel());
        component.attributes(AttributeOperation.OVERLAY, "conan", conanAttributes);
    }

    private boolean isNewRepositoryContent(RepositoryContent repositoryContent) {
        return repositoryContent.attributes().isEmpty();
    }
}

