/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.repository.conan.internal.common;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.security.SecurityHandler;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.Route;
import org.sonatype.nexus.repository.view.Router;
import org.sonatype.nexus.repository.view.handlers.ExceptionHandler;
import org.sonatype.nexus.repository.view.handlers.HandlerContributor;
import org.sonatype.nexus.repository.view.handlers.TimingHandler;
import org.sonatype.nexus.repository.view.matchers.ActionMatcher;
import org.sonatype.nexus.repository.view.matchers.logic.LogicMatchers;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class PingController
extends ComponentSupport {
    private static final String PING = "/%s/ping";
    @Inject
    TimingHandler timingHandler;
    @Inject
    SecurityHandler securityHandler;
    @Inject
    ExceptionHandler exceptionHandler;
    @Inject
    HandlerContributor handlerContributor;
    public final Handler pingHandler = context -> {
        this.log.debug("pong");
        return HttpResponses.ok();
    };

    private static Route.Builder ping(String version) {
        return new Route.Builder().matcher(LogicMatchers.and((Matcher[])new Matcher[]{new ActionMatcher(new String[]{"GET"}), new TokenMatcher(String.format(PING, version))}));
    }

    public void attach(Router.Builder builder, String version) {
        builder.route(PingController.ping(version).handler((Handler)this.timingHandler).handler((Handler)this.securityHandler).handler((Handler)this.exceptionHandler).handler((Handler)this.handlerContributor).handler(this.pingHandler).create());
    }
}

