/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.maven.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.maven.internal.MavenRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.content.maven.MavenContentFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="maven2")
@Singleton
public class MavenRestoreBlobStrategy
extends BaseRestoreBlobStrategy<MavenRestoreBlobData> {
    private final RepositoryManager repositoryManager;
    private final MavenPathParser mavenPathParser;

    @Inject
    protected MavenRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager, MavenPathParser mavenPathParser) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    protected boolean canAttemptRestore(@Nonnull MavenRestoreBlobData data) {
        MavenPath mavenPath = data.getMavenPath();
        Repository repository = data.getRepository();
        if (mavenPath.getCoordinates() == null && !this.mavenPathParser.isRepositoryMetadata(mavenPath)) {
            this.log.warn("Skipping blob in repository named {}, because no maven coordinates found for blob named {} in blob store named {} and the blob not maven metadata", new Object[]{repository.getName(), data.getBlobName(), data.getBlobStore().getBlobStoreConfiguration().getName()});
            return false;
        }
        Optional mavenFacet = repository.optionalFacet(MavenContentFacet.class);
        if (!mavenFacet.isPresent()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Skipping as Maven Content Facet not found on repository: {}", (Object)repository.getName());
            }
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, MavenRestoreBlobData data) throws IOException {
        MavenContentFacet mavenFacet = (MavenContentFacet)data.getRepository().facet(MavenContentFacet.class);
        mavenFacet.put(data.getMavenPath(), (Payload)new DetachedBlobPayload(assetBlob));
    }

    protected String getAssetPath(@Nonnull MavenRestoreBlobData data) {
        return data.getMavenPath().getPath();
    }

    protected MavenRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new MavenRestoreBlobData(blob, properties, blobStore, this.repositoryManager, this.mavenPathParser);
    }

    protected boolean isComponentRequired(MavenRestoreBlobData data) {
        MavenPath path = data.getMavenPath();
        return !this.mavenPathParser.isRepositoryIndex(path) && !this.mavenPathParser.isRepositoryMetadata(path);
    }

    public void after(boolean updateAssets, Repository repository) {
    }
}

