/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.security;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.security.UserPrincipalsExpired;
import org.sonatype.nexus.security.authc.UserPasswordChanged;
import org.sonatype.nexus.security.authz.AuthorizationConfigurationChanged;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
public class HazelcastSecurityDistributor
extends HazelcastDistributorSupport
implements EventAware,
MessageListener<String> {
    static final String TOPIC_NAME = "nexus:security";
    static final String AUTHZ_CONFIG_CHANGED = "AuthorizationConfigurationChanged";
    static final String PRINCIPALS_EXPIRED = "UserPrincipalsExpired";
    static final String PASSWORD_CHANGED = "UserPasswordChanged";
    static final String ID_SEPARATOR = ":";
    private final Provider<HazelcastInstance> hazelcastProvider;
    private final EventManager eventManager;
    private ITopic<String> topic;
    private String messageListenerId;

    @Inject
    public HazelcastSecurityDistributor(NodeAccess nodeAccess, Provider<HazelcastInstance> hazelcastProvider, EventManager eventManager) {
        super(nodeAccess);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    protected void doStartCluster() throws Exception {
        this.topic = ((HazelcastInstance)this.hazelcastProvider.get()).getTopic(TOPIC_NAME);
        this.messageListenerId = this.topic.addMessageListener((MessageListener)this);
    }

    @Override
    protected void doStopCluster() throws Exception {
        this.topic.removeMessageListener(this.messageListenerId);
    }

    @Subscribe
    public void on(AuthorizationConfigurationChanged event) {
        this.maybePublish(event, new String[0]);
    }

    @Subscribe
    public void on(UserPrincipalsExpired event) {
        this.maybePublish(event, event.getUserId(), event.getSource());
    }

    @Subscribe
    public void on(UserPasswordChanged event) {
        this.maybePublish(event, event.getUserId());
    }

    public void onMessage(Message<String> message) {
        if (!message.getPublishingMember().localMember()) {
            String msg = (String)message.getMessageObject();
            this.log.debug("Receiving {} from remote node {}", (Object)msg, (Object)message.getPublishingMember());
            String[] parts = msg.split(ID_SEPARATOR);
            this.runAsRemote(() -> {
                switch (parts[0]) {
                    case "AuthorizationConfigurationChanged": {
                        this.eventManager.post((Object)new AuthorizationConfigurationChanged());
                        break;
                    }
                    case "UserPrincipalsExpired": {
                        if (parts.length == 3) {
                            this.eventManager.post((Object)new UserPrincipalsExpired(HazelcastSecurityDistributor.decodeId(parts[1]), HazelcastSecurityDistributor.decodeId(parts[2])));
                            break;
                        }
                        this.log.warn("Cannot distribute malformed event {}", (Object)msg);
                        break;
                    }
                    case "UserPasswordChanged": {
                        if (parts.length == 2) {
                            this.eventManager.post((Object)new UserPasswordChanged(HazelcastSecurityDistributor.decodeId(parts[1])));
                            break;
                        }
                        this.log.warn("Cannot distribute malformed event {}", (Object)msg);
                        break;
                    }
                    default: {
                        this.log.warn("Cannot distribute unknown security event {}", (Object)msg);
                    }
                }
            });
        }
    }

    private void maybePublish(Object event, String ... ids) {
        if (!this.isClustered() || this.isRunningAsRemote()) {
            return;
        }
        this.log.debug("Distributing {} to other nodes of cluster", event);
        StringBuilder msg = new StringBuilder(event.getClass().getSimpleName());
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            msg.append(ID_SEPARATOR).append(HazelcastSecurityDistributor.encodeId(id));
            ++n2;
        }
        this.topic.publish((Object)msg.toString());
    }

    static String encodeId(String id) {
        return id != null ? Strings2.encodeBase64((String)id) : "";
    }

    static String decodeId(String encodedId) {
        return !encodedId.isEmpty() ? Strings2.decodeBase64((String)encodedId) : null;
    }
}

