/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.hazelcast.internal.scheduling.ClusteredTaskStateStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.events.TaskDeletedEvent;
import org.sonatype.nexus.scheduling.events.TaskEvent;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class LocalTaskStateTracker
extends StateGuardLifecycleSupport
implements EventAware {
    private final ClusteredTaskStateStore clusteredTaskStateStore;
    private final TaskScheduler taskScheduler;

    @Inject
    public LocalTaskStateTracker(ClusteredTaskStateStore clusteredTaskStateStore, TaskScheduler taskScheduler) {
        this.clusteredTaskStateStore = (ClusteredTaskStateStore)Preconditions.checkNotNull((Object)clusteredTaskStateStore);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() throws Exception {
        this.log.debug("Recording initial task states");
        this.taskScheduler.listsTasks().stream().forEach(this.clusteredTaskStateStore::setLocalState);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEvent event) {
        this.log.debug("Updating task state for event {}", (Object)event);
        if (event instanceof TaskDeletedEvent) {
            this.clusteredTaskStateStore.removeClusteredState(event.getTaskInfo().getId());
        } else {
            this.clusteredTaskStateStore.setLocalState(event.getTaskInfo());
        }
    }
}

