/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.sonatype.nexus.hazelcast.internal.HazelcastDistributorSupport;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.events.TaskEventCanceled;
import org.sonatype.nexus.scheduling.events.TaskEventStarted;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class HazelcastTaskDistributor
extends HazelcastDistributorSupport
implements EventAware,
EventAware.Asynchronous,
MessageListener<String> {
    private static final String TRIGGER_SOURCE = HazelcastTaskDistributor.class.getName();
    private final SchedulerSPI schedulerSPI;
    private final Provider<HazelcastInstance> hazelcastProvider;
    private ITopic<String> topic;
    private String messageListenerId;

    @Inject
    public HazelcastTaskDistributor(SchedulerSPI schedulerSPI, Provider<HazelcastInstance> hazelcastProvider, NodeAccess nodeAccess) {
        super(nodeAccess);
        this.schedulerSPI = (SchedulerSPI)Preconditions.checkNotNull((Object)schedulerSPI);
        this.hazelcastProvider = (Provider)Preconditions.checkNotNull(hazelcastProvider);
    }

    @Override
    protected void doStartCluster() throws Exception {
        this.topic = ((HazelcastInstance)this.hazelcastProvider.get()).getTopic("nexus:task");
        this.messageListenerId = this.topic.addMessageListener((MessageListener)this);
    }

    @Override
    protected void doStopCluster() throws Exception {
        this.topic.removeMessageListener(this.messageListenerId);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEventStarted event) {
        if (this.isClustered()) {
            this.sendMessage(TaskAction.START, event.getTaskInfo());
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEventCanceled event) {
        if (this.isClustered()) {
            this.sendMessage(TaskAction.CANCEL, event.getTaskInfo());
        }
    }

    private void sendMessage(TaskAction action, TaskInfo taskInfo) {
        if (action == TaskAction.START && TRIGGER_SOURCE.equals(taskInfo.getTriggerSource())) {
            return;
        }
        if (taskInfo.getConfiguration().getBoolean("multinode", false)) {
            this.log.debug("Distributing request to {} task {} across the cluster", (Object)action, (Object)taskInfo.getId());
            this.topic.publish((Object)((Object)((Object)action) + ":" + taskInfo.getId()));
        }
    }

    public void onMessage(Message<String> message) {
        Member sender = message.getPublishingMember();
        if (!sender.localMember()) {
            String request = (String)message.getMessageObject();
            int separator = request.indexOf(58);
            TaskAction action = TaskAction.valueOf(request.substring(0, separator));
            String taskId = request.substring(separator + 1);
            this.log.debug("Receiving request to {} task {} from remote node {}", new Object[]{action, taskId, sender});
            TaskInfo taskInfo = this.schedulerSPI.getTaskById(taskId);
            if (taskInfo == null) {
                this.log.debug("Ignoring missing task {}", (Object)taskId);
                return;
            }
            try {
                switch (action) {
                    case START: {
                        taskInfo.runNow(TRIGGER_SOURCE);
                        break;
                    }
                    case CANCEL: {
                        Future future = taskInfo.getCurrentState().getFuture();
                        if (future != null && !future.isCancelled()) {
                            future.cancel(false);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to {} task {} as requested by remote node {}", new Object[]{action, taskId, sender, e});
            }
        }
    }

    private static enum TaskAction {
        START,
        CANCEL;

    }
}

