/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.scheduling;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.TaskState;

public class ClusteredTaskState {
    private final String nodeId;
    private final TaskState state;
    private final TaskState runState;
    private final TaskState lastEndState;
    private final Date lastRunStarted;
    private final Long lastRunDuration;

    public ClusteredTaskState(String nodeId, TaskState state, @Nullable TaskState runState, @Nullable TaskState lastEndState, @Nullable Date lastRunStarted, @Nullable Long lastRunDuration) {
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
        this.state = (TaskState)Preconditions.checkNotNull((Object)state);
        this.runState = runState;
        this.lastEndState = lastEndState;
        this.lastRunStarted = lastRunStarted;
        this.lastRunDuration = lastRunDuration;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public TaskState getState() {
        return this.state;
    }

    @Nullable
    public TaskState getRunState() {
        return this.runState;
    }

    @Nullable
    public TaskState getLastEndState() {
        return this.lastEndState;
    }

    @Nullable
    public Date getLastRunStarted() {
        return this.lastRunStarted;
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.lastRunDuration;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{nodeId=" + this.nodeId + ", state=" + this.state + ", runState=" + this.runState + ", lastEndState=" + this.lastEndState + ", lastRunStarted=" + this.lastRunStarted + ", lastRunDuration=" + this.lastRunDuration + "}";
    }
}

