/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.hazelcast.internal.scheduling;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.hazelcast.internal.scheduling.ClusteredTaskState;
import com.sonatype.nexus.hazelcast.internal.scheduling.ClusteredTaskStateStore;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.TaskFactory;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskSchedulerImpl;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Singleton
@Priority(value=0x7FFFFFFF)
@Named
public class ClusteredTaskSchedulerImpl
extends TaskSchedulerImpl {
    private final ClusteredTaskStateStore clusteredTaskStateStore;

    @Inject
    public ClusteredTaskSchedulerImpl(EventManager eventManager, TaskFactory taskFactory, ClusteredTaskStateStore clusteredTaskStateStore, Provider<SchedulerSPI> scheduler) {
        super(eventManager, taskFactory, scheduler);
        this.clusteredTaskStateStore = (ClusteredTaskStateStore)Preconditions.checkNotNull((Object)clusteredTaskStateStore);
    }

    private List<ClusteredTaskState> getClusteredTaskStateById(String taskId) {
        Preconditions.checkNotNull((Object)taskId);
        return this.clusteredTaskStateStore.getClusteredState(taskId);
    }

    public ExternalTaskState toExternalTaskState(TaskInfo taskInfo) {
        List<ClusteredTaskState> clusteredTaskStates = this.getClusteredTaskStateById(taskInfo.getId());
        if (clusteredTaskStates != null) {
            return new ExternalTaskState(ClusteredTaskSchedulerImpl.getAggregateState(clusteredTaskStates), ClusteredTaskSchedulerImpl.getAggregateEndState(clusteredTaskStates), ClusteredTaskSchedulerImpl.getAggregateLastRun(clusteredTaskStates), ClusteredTaskSchedulerImpl.getAggregateRunDuration(clusteredTaskStates));
        }
        return new ExternalTaskState(taskInfo);
    }

    @VisibleForTesting
    static TaskState getAggregateState(List<ClusteredTaskState> clusteredTaskStates) {
        Set states = clusteredTaskStates.stream().map(ClusteredTaskState::getState).collect(Collectors.toSet());
        return (TaskState)ClusteredTaskSchedulerImpl.findTopPriorityState(states, ImmutableList.of((Object)TaskState.RUNNING, (Object)TaskState.WAITING, (Object)TaskState.OK));
    }

    @VisibleForTesting
    static TaskState getAggregateEndState(List<ClusteredTaskState> clusteredTaskStates) {
        Set states = clusteredTaskStates.stream().map(ClusteredTaskState::getLastEndState).collect(Collectors.toSet());
        return (TaskState)ClusteredTaskSchedulerImpl.findTopPriorityState(states, ImmutableList.of((Object)TaskState.FAILED, (Object)TaskState.CANCELED, (Object)TaskState.INTERRUPTED, (Object)TaskState.OK));
    }

    @VisibleForTesting
    static Date getAggregateLastRun(List<ClusteredTaskState> clusteredTaskStates) {
        return clusteredTaskStates.stream().filter(Objects::nonNull).map(ClusteredTaskState::getLastRunStarted).filter(Objects::nonNull).max(Date::compareTo).orElse(null);
    }

    @VisibleForTesting
    static Long getAggregateRunDuration(List<ClusteredTaskState> clusteredTaskStates) {
        return clusteredTaskStates.stream().filter(Objects::nonNull).map(ClusteredTaskState::getLastRunDuration).filter(Objects::nonNull).max(Long::compare).orElse(null);
    }

    private static <E> E findTopPriorityState(Set<E> states, List<E> priorities) {
        for (E priority : priorities) {
            if (!states.contains(priority)) continue;
            return priority;
        }
        return null;
    }
}

